% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s4_subset_extract.R
\name{extract-odm}
\alias{extract-odm}
\alias{[[,ondisc_matrix,missing,missing-method}
\alias{[[,ondisc_matrix,ANY,missing-method}
\alias{[[,ondisc_matrix,missing,ANY-method}
\alias{[[,ondisc_matrix,ANY,ANY-method}
\alias{[[,metadata_ondisc_matrix,ANY,ANY-method}
\alias{[[,multimodal_ondisc_matrix,ANY,ANY-method}
\title{Pull a submatrix into memory using the \code{[[} operator.}
\usage{
\S4method{[[}{ondisc_matrix,missing,missing}(x, i, j)

\S4method{[[}{ondisc_matrix,ANY,missing}(x, i, j)

\S4method{[[}{ondisc_matrix,missing,ANY}(x, i, j)

\S4method{[[}{ondisc_matrix,ANY,ANY}(x, i, j)

\S4method{[[}{metadata_ondisc_matrix,ANY,ANY}(x, i, j)

\S4method{[[}{multimodal_ondisc_matrix,ANY,ANY}(x, i, j)
}
\arguments{
\item{x}{an \code{ondisc_matrix} object.}

\item{i}{a vector (numeric, logical, or character) indicating features to pull into memory.}

\item{j}{a vector (numeric, logical, or character) indicating cells to pull into memory.}
}
\value{
a matrix (as implemented by the Matrix package).
}
\description{
Apply the \code{[[} operator to an \code{ondisc_matrix} to pull a submatrix into memory. You can pass logical, character,
or numeric vectors to \code{[[}; character vectors are assumed to refer to feature IDs (for rows) and cell barcodes
(for columns).
}
\details{
You can apply \code{[[} to \code{ondisc_matrix} objects only. You cannot apply \code{[[} to \code{metadata_ondisc_matrix} or
\code{multimodal_ondisc_matrix} objects, because in the latter case the data to be accessed is ambiguous.

You can remember the difference between \code{[} and \code{[[} by thinking about R lists: \code{[} is used to subset a list, and
\code{[[} is used to access elements stored \emph{inside} a list. Similarly, \code{[} is used to subset an \code{ondisc_matrix}, and
\code{[[} is used to access a submatrix usable within R.
}
\examples{
# NOTE: You must create the HDF5 file "expressions.h5" to run this example.
# Navigate to the help file of "create_ondisc_matrix_from_mtx"
# (via ?create_ondisc_matrix_from_mtx), and execute the code in the first code block.

h5_fp <- paste0(tempdir(), "/expressions.h5")
if (file.exists(h5_fp)) {
odm <- ondisc_matrix(h5_file = h5_fp)
# extract cells 100-110:
x <- odm[[,100:110]]
# extract genes ENSG00000188305, ENSG00000257284, ENSG00000251655:
x <- odm[[c("ENSG00000188305", "ENSG00000257284", "ENSG00000251655"),]]
# extract cells CTTAGGACACTGGCGT-1 and AAAGGATTCACATCAG-1:
x <- odm[[,c("CTTAGGACACTGGCGT-1", "AAAGGATTCACATCAG-1")]]
}
}
