% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s4_classes.R
\name{ondisc_matrix}
\alias{ondisc_matrix}
\title{\code{ondisc_matrix} class}
\usage{
ondisc_matrix(h5_file)

ondisc_matrix(h5_file)
}
\arguments{
\item{h5_file}{a .h5 file storing the on-disk portion of an initialized \code{ondisc_matrix} object.}
}
\value{
an initialized \code{ondisc_matrix} object.
}
\description{
An \code{ondisc_matrix} represents a feature-by-cell expression matrix stored on-disk.

Construct an \code{ondisc_matrix} from an initialized .h5 file.
}
\details{
It is best to avoid interacting with the slots of an \code{ondisc_matrix} directly. Instead, use the functions
and operators provided by the package.
}
\section{Slots}{

\describe{
\item{\code{h5_file}}{path to an initialized .h5 file stored on-disk.}

\item{\code{logical_mat}}{logical value indicating whether the matrix is logical.}

\item{\code{cell_subset}}{integer vector recording the cells currently in use.}

\item{\code{feature_subset}}{integer vector recording the features currently in use.}

\item{\code{underlying_dimension}}{the dimension of the (unsubset) expression matrix.}
}}

\examples{
# NOTE: You must create the HDF5 file "expressions.h5" to run this example.
# Navigate to the help file of "create_ondisc_matrix_from_mtx"
# (via ?create_ondisc_matrix_from_mtx), and execute the code in the first code block.
h5_fp <- paste0(tempdir(), "/expressions.h5")
if (file.exists(h5_fp)) {
  odm <- ondisc_matrix(h5_file = h5_fp)
}
}
