% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/onemap_read_vcfR.R
\name{onemap_read_vcfR}
\alias{onemap_read_vcfR}
\title{Convert vcfR object to onemap object}
\usage{
onemap_read_vcfR(vcfR.object = NULL, cross = c("outcross",
  "f2 intercross", "f2 backcross", "ri self", "ri sib"), parent1 = NULL,
  parent2 = NULL)
}
\arguments{
\item{vcfR.object}{object of class 'vcfR' from vcfR package.}

\item{cross}{type of cross. Must be one of: \code{"outcross"} for full-sibs;
\code{"f2 intercross"} for an F2 intercross progeny; \code{"f2 backcross"};
\code{"ri self"} for recombinant inbred lines by self-mating; or
\code{"ri sib"} for recombinant inbred lines by sib-mating.}

\item{parent1}{\code{string} specifying sample ID of the first parent.}

\item{parent2}{\code{string} specifying sample ID of the second parent.}
}
\description{
Converts data from a vcfR package to onemap initial object, while trying to identify 
the appropriate marker segregation patterns.
}
\details{
Only biallelic SNPs and indels for diploid variant sites are considered.

Genotype information on the parents is required for all cross types. For
full-sib progenies, both outbred parents must be genotyped. For backcrosses,
F2 intercrosses and recombinant inbred lines, the \emph{original inbred
lines} must be genotyped. Particularly for backcross progenies, the
\emph{recurrent line must be provided as the first parent} in the function
arguments.

Marker type is determined based on parental genotypes. Variants for which parent
genotypes cannot be determined are discarded.

Reference sequence ID and position for each variant site are also stored.
}
\examples{

\dontrun{
vcfR.object <- vcfR::read.vcfR(system.file("extdata/vcf_example_out.vcf", package = "onemap"))
data <- onemap_read_vcfR(vcfR.object=vcfR.object,
                 cross="outcross",
                 parent1=c("P1"),
                 parent2=c("P2"))
}
                
}
\seealso{
\code{read_onemap} for a description of the output object of class onemap.
}
\author{
Cristiane Taniguti, \email{chtaniguti@usp.br}
}
