% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/onemap_read_vcfR.R
\name{write_onemap_raw}
\alias{write_onemap_raw}
\title{Convert onemap object to onemap raw file}
\usage{
write_onemap_raw(
  onemap.obj = NULL,
  file.name = "out.raw",
  cross = c("outcross", "f2 backcross", "f2 intercross", "ri self", "ri sib")
)
}
\arguments{
\item{onemap.obj}{object of class `onemap`}

\item{file.name}{a character for the onemap raw file name. Default is "out.raw"}

\item{cross}{a character describing the cross type. It can be "outcrossing", 
"f2 intercross", "f2 backcross", "ri self" or "ri sib"}
}
\description{
Converts onemap R object to onemap input file. The input file brings information about the mapping population:
First line: cross type, it can be "outcrossing", "f2 intercross", "f2 backcross", "ri self" or "ri sib".
Second line:  number of individuals, number of markers, presence (1) or absence (0) of chromossome and position of the markers, and number of phenotypes mesured.
Third line: Individuals/sample names; 
Followed lines: marker name, marker type and genotypes. One line for each marker.
Final lines: chromossome, position and phenotypes informations. 
See more about input file format at vignettes.
}
\examples{
\dontrun{
data(onemap_example_out)

write_onemap_raw(onemap_example_out, file.name = "onemap_example_out.raw", cross="outcross")
}
}
\seealso{
\code{read_onemap} for a description of the output object of class onemap.
}
\author{
Cristiane Taniguti, \email{chtaniguti@usp.br}
}
