% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.R
\name{map_avoid_unlinked}
\alias{map_avoid_unlinked}
\title{Repeat HMM if map find unlinked marker}
\usage{
map_avoid_unlinked(
  input.seq,
  size = NULL,
  overlap = NULL,
  phase_cores = 1,
  tol = 1e-04,
  parallelization.type = "PSOCK",
  max.gap = FALSE,
  global_error = NULL,
  genotypes_errors = NULL,
  genotypes_probs = NULL
)
}
\arguments{
\item{input.seq}{object of class sequence}

\item{size}{The center size around which an optimum is to be searched}

\item{overlap}{The desired overlap between batches}

\item{phase_cores}{The number of parallel processes to use when estimating
the phase of a marker. (Should be no more than 4)}

\item{tol}{tolerance for the C routine, i.e., the value used to evaluate
convergence.}

\item{parallelization.type}{one of the supported cluster types. This should 
be either PSOCK (default) or FORK.}

\item{max.gap}{the marker will be removed if it have gaps higher than this defined threshold in both sides}

\item{global_error}{single value to be considered as error probability in HMM emission function}

\item{genotypes_errors}{matrix individuals x markers with error values for each marker}

\item{genotypes_probs}{table containing the probability distribution for each combination of marker × individual. 
Each line on this table represents the combination of one marker with one individual, and the respective probabilities.
The table should contain four three columns (prob(AA), prob(AB) and prob(BB)) and individuals*markers rows.}
}
\value{
An object of class \code{sequence}, which is a list containing the
following components: \item{seq.num}{a \code{vector} containing the
(ordered) indices of markers in the sequence, according to the input file.}
\item{seq.phases}{a \code{vector} with the linkage phases between markers
in the sequence, in corresponding positions. \code{-1} means that there are
no defined linkage phases.} \item{seq.rf}{a \code{vector} with the
recombination frequencies between markers in the sequence. \code{-1} means
that there are no estimated recombination frequencies.}
\item{seq.like}{log-likelihood of the corresponding linkage map.}
\item{data.name}{name of the object of class \code{onemap} with the raw
data.} \item{twopt}{name of the object of class \code{rf_2pts} with the
2-point analyses.}
}
\description{
Repeat HMM if map find unlinked marker
}
\examples{

\donttest{
  data(onemap_example_out)
  twopt <- rf_2pts(onemap_example_out)

  markers <- make_seq(twopt,c(30,12,3,14,2)) # correct phases
  map_avoid_unlinked(markers)

  markers <- make_seq(twopt,c(30,12,3,14,2),phase=c(4,1,4,3)) # incorrect phases
  map_avoid_unlinked(markers)
}
   
}
