% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_tday.R
\name{make_tday}
\alias{make_tday}
\title{Make an hour-of-day forecast matrix}
\usage{
make_tday(time, kseq, tstep = NA)
}
\arguments{
\item{time}{vector of times of class "POSIXct" "POSIXt".}

\item{kseq}{vector of integers, representing the desired "k-steps ahead".}

\item{tstep}{step time of k in seconds.}
}
\value{
Returns a forecast matrix (data.frame) with rownames = times, colnames = k1, k2, k3, ...
The content of the data frame is the hour of day.
}
\description{
This function creates a data.frame with k-steps-ahead values of hour of day,
such that it can be added to a data.list and used inputs to a forecast model.
}
\examples{
# Create a time sequence of 30 min sample period
tseq <- seq(ct("2019-01-01"), ct("2019-02-01 12:00"), by=1800)

# Make the time of day sequence (assuming time between k steps is same as for tseq)
make_tday(tseq, 1:10)

# With 0.5 hour steps, kstep in hours
make_tday(tseq, 1:10, tstep=3600)


}
\seealso{
make_periodic
}
\keyword{data.frame}
\keyword{hourofday}
\keyword{lags}
