% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.list.R
\name{subset.data.list}
\alias{subset.data.list}
\title{Take a subset of a data.list.}
\usage{
\method{subset}{data.list}(
  x,
  subset = NA,
  nms = NA,
  kseq = NA,
  lagforecasts = FALSE,
  pattern = NA,
  ...
)
}
\arguments{
\item{x}{The data.list to take a subset of.}

\item{subset}{Given as the integer indexes or a logical vector, or alternatively \code{c(tstart,tend)}, where tstart and tend are either as POSIX or characters.}

\item{nms}{The names of the variables in \code{x} to be included.}

\item{kseq}{The k horizons of forecasts to be included.}

\item{lagforecasts}{Should the forecasts be lagged k steps (thus useful for plotting etc.).}

\item{pattern}{Regex pattern applied to select the variables in x to be included.}

\item{...}{Not implemented.}
}
\value{
a data.list with the subset.
}
\description{
Take a subset of a data.list.
}
\details{
Different arguments can be given to select the subset. See the examples.
}
\examples{
# Use the data.list with building heat load 
D <- Dbuilding
# Take a subset for the example
D <- subset(D, 1:10, nms=c("t","Taobs","Ta","Iobs","I"), kseq=1:3)

# Take subset index 2:4
subset(D, 2:4)

# Take subset for a period
subset(D, c("2010-12-15 02:00","2010-12-15 04:00"))

# Cannot request a variable not there
try(subset(D, nms=c("x","Ta")))

# Take specific horizons
subset(D, nms=c("I","Ta"), kseq = 1:2)
subset(D, nms=c("I","Ta"), kseq = 1)

# Lag the forecasts such that they are aligned in time with observations
subset(D, nms=c("Taobs","Ta"), kseq = 2:3, lagforecasts = TRUE)

# The order follows the order in nms
subset(D, nms=c("Ta","I"), kseq = 2)

# Return variables mathing a regex
subset(D, kseq=2, pattern="^I")

# Take data for Ta and lag the forecasts (good for plotting and fitting a model)
X <- subset(Dbuilding, 1:1000, pattern="^Ta", kseq = 10, lagforecasts = TRUE)

# A scatter plot between the forecast and the observations
# (try lagforecasts = FALSE and see the difference)
plot(X$Ta$k10, X$Taobs)

# Fit a model for the 10-step horizon
abline(lm(Taobs ~ Ta.k10, X), col=2)

}
