% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_quantums.R
\name{plot_quantums}
\alias{plot_quantums}
\title{plot_quantums}
\usage{
plot_quantums(
  input,
  labels = NULL,
  color_scale = NULL,
  legend_position = "bottom",
  quantum_position = NULL,
  title = NULL,
  xlab = NULL,
  ylab = NULL,
  line_size = 0.5,
  base_size = 15,
  full_fun = TRUE,
  quantum = TRUE,
  standarized = FALSE
)
}
\arguments{
\item{input}{envelope.}

\item{labels}{Name of the labels. See details for more information.}

\item{color_scale}{Colors used with labels.}

\item{legend_position}{The position of legends ("none", "left", "right", "bottom", "top", or two-element numeric vector)}

\item{quantum_position}{Vector with minimum and maximum y value of the quantum bar.}

\item{title}{Plot title.}

\item{xlab, ylab}{axis labels.}

\item{line_size}{Size of the lines.}

\item{base_size}{Base font size.}

\item{full_fun}{If true observed value and envelope is plotted.}

\item{quantum}{If true quantums bars are plotted.}

\item{standarized}{If true observed value is standardized. See details for more details.}
}
\value{
ggplot
}
\description{
Plot simulation envelopes
}
\details{
This functions provides a plotting style for envelope objects of the spatstat
package (for more information please see \code{spatstat.explore::envelope}). The location of the
observed value in relation to the simulation envelope of the null model input is
indicated by an additional colour bar at the bottom of the plot. If \code{standarized = TRUE},
all values are standarized by subtracting the theoretical value for CSR

Labels must be a vector including labels for the following three cases. The color
scale vector is used in the same order.
\cr 1 = observed > high
\cr 2 = low < observed < high
\cr 3 = observed < low

To adjust the position of the quantum bar, use \code{quantum_position}.

Returns a \code{ggplot} object.
}
\examples{
set.seed(42)
pattern <- spatstat.random::rThomas(kappa = 50, scale = 0.025, mu = 5)
csr_envelope <- spatstat.explore::envelope(pattern, fun = spatstat.explore::pcf, nsim = 19)
plot_quantums(csr_envelope, ylab = "g(r)")

}
\references{
Esser, D.S., Leveau, J.H.J., Meyer, K.M., Wiegand, K., 2015. Spatial scales of
interactions among bacteria and between bacteria and the leaf surface.
FEMS Microbiology Ecology 91, 1–13. <https://doi.org/10.1093/femsec/fiu034>
}
\seealso{
\code{\link{envelope}}
}
