% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new_concept.R
\name{new_concept}
\alias{new_concept}
\title{Add a new concept to an ontology}
\usage{
new_concept(
  new,
  broader = NULL,
  description = NULL,
  class = NULL,
  ontology = NULL
)
}
\arguments{
\item{new}{\code{\link[=character]{character(.)}}\cr the english label(s) of new
concepts that shall be included in the ontology.}

\item{broader}{\code{\link[=data.frame]{data.frame(.)}}\cr the english label(s) of
already harmonised concepts to which the new concept shall be semantically
linked via a
\href{https://www.w3.org/TR/skos-reference/#semantic-relations}{skos:broader}
relation, see Details.}

\item{description}{\code{\link[=character]{character(.)}}\cr a verbatim description of
the new concept(s).}

\item{class}{\code{\link[=character]{character(.)}}\cr the class(es) of the new labels.}

\item{ontology}{\code{\link[=list]{ontology(1)}}\cr either a path where the ontology is
stored, or an already loaded ontology.}
}
\value{
returns invisibly a table of the new harmonised concepts that were
added to the ontology, or a message that nothing new was added.
}
\description{
This adds a new concept to an existing ontology to semantically integrate and
thus harmonise it with the already existing ontology.
}
\examples{
ontoDir <- system.file("extdata", "crops.rds", package = "ontologics")
onto <- load_ontology(path = ontoDir)

# add fully known concepts
concepts <- data.frame(
  old = c("Bioenergy woody", "Bioenergy herbaceous"),
  new = c("acacia", "miscanthus")
)

onto <- new_source(
  version = "0.0.1",
  name = "externalDataset",
  description = "a vocabulary",
  homepage = "https://www.something.net",
  license = "CC-BY-0",
  ontology = onto
)

onto <- new_concept(
  new = concepts$new,
  broader = get_concept(label = concepts$old, ontology = onto),
  class = "crop",
  ontology = onto
)

# add concepts where the nesting is clear, but not the new class
concepts <- data.frame(
  old = c("Barley", "Barley"),
  new = c("food", "bio-energy")
)

onto <- new_concept(
  new = concepts$new,
  broader = get_concept(label = concepts$old, ontology = onto),
  ontology = onto
)

# define that class ...
onto <- new_class(
  new = "use type", target = "class",
  description = "the way a crop is used", ontology = onto
)

# ... and set the concepts again
onto <- new_concept(
  new = concepts$new,
  broader = get_concept(label = concepts$old, ontology = onto),
  class = "use type",
  ontology = onto
)

}
