% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{ontology_index}
\alias{ontology_index}
\title{Create \code{ontology_index} object from vectors and lists of term properties}
\usage{
ontology_index(id, name, parents, remove_missing = FALSE,
  obsolete = setNames(nm = id, rep(FALSE, length(id))), version = NULL, ...)
}
\arguments{
\item{id}{Character vector of term IDs.}

\item{name}{Character vector of term labels.}

\item{parents}{List of character vectors of parents per term.}

\item{remove_missing}{Logical value determining whether the parents in parent-child relationships in the ontology should be removed from the index. If there are parents which are missing, failure to remove them will lead to an error.}

\item{obsolete}{Logical vector indicating whether given terms are obsolete.}

\item{version}{Version information about the ontology.}

\item{...}{Additional arguments, each of which should be either a vector or list of term properties.}
}
\description{
Create \code{ontology_index} object from vectors and lists of term properties
}

