% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhpp_functions.R
\name{estimate_edge_KDE_Markov_kernel_unnorm}
\alias{estimate_edge_KDE_Markov_kernel_unnorm}
\title{Estimate the unnormalized Markov KDE}
\usage{
estimate_edge_KDE_Markov_kernel_unnorm(tree.discr, Path.data, h = 10)
}
\arguments{
\item{tree.discr}{simmap or phylo object. A discretized tree using the 'discr_Simmap' function.}

\item{Path.data}{numeric. A list of path data obtained from the 'make_data_NHPP_KDE_Markov_kernel' function.}

\item{h}{numeric. A value for the bandwidth calculated using the 'estimate_band_W' function.}
}
\value{
A list with the estimated unnormalized KDEs ($Maps.mean) for each edge.
}
\description{
Estimated the unnormalized Markov KDE for each edge averaged across all possible root-tip paths.
}
\examples{
data("hym_nhpp", "hym_tree")
# Get reference tree.
tree_discr <- discr_Simmap(hym_tree, res = 200)
# Make NHPP path data.
nhpp <- hym_nhpp$head
# Add pseudo data to path data.
psd <- lapply(nhpp, function(x) -x[x < 100] )
edge_groups <- as.list(1:length(hym_tree$edge.length))
nhpp_psd <- add_pseudodata(Edge.groups = edge_groups, Pseudo.data = psd, Path.data = nhpp)
# Calculate bandwidth.
bdw <- estimate_band_W(tree_discr, nhpp_psd, band.width = "bw.nrd0")
bdw <- mean(bdw)
# Estimate non-normalized and normalized edge KDE.
Edge_KDE <- estimate_edge_KDE_Markov_kernel_unnorm(tree_discr, nhpp_psd, h = bdw)
# Check KDE data for non-normalized mean rates from an arbitrary branch.
Edge_KDE$Maps.mean[[5]]

}
\author{
Sergei Tarasov
}
