% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.assign.r
\name{opal.assign.script}
\alias{opal.assign.script}
\title{R script assignment}
\usage{
opal.assign.script(opal, symbol, value, async = FALSE)
}
\arguments{
\item{opal}{Opal object or list of opal objects.}

\item{symbol}{Name of the R symbol.}

\item{value}{The R expression to assign.}

\item{async}{R script is executed asynchronously within the session (default is FALSE). If TRUE, the value returned is the ID of the command to look for (from Opal 2.1).}
}
\description{
Assign a R script or expression to a R symbol in the current R session.
}
\examples{
\donttest{
o <- opal.login('administrator','password','https://opal-demo.obiba.org')
# assign a function and call it
opal.assign.script(o, 'hello', quote(function(x) { print(paste0('Hello ', x , '!'))}))
opal.execute(o, "hello('Mr Bean')")
opal.logout(o)
}
}
\seealso{
Other assignment functions: 
\code{\link{opal.assign.data}()},
\code{\link{opal.assign.resource}()},
\code{\link{opal.assign.table.tibble}()},
\code{\link{opal.assign.table}()},
\code{\link{opal.assign}()}
}
\concept{assignment functions}
