% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dictionary.annotations.R
\name{harmo.annotate}
\alias{harmo.annotate}
\title{Set variable annotation with a taxonomy term (deprecated)}
\usage{
harmo.annotate(
  tibble,
  variables = NULL,
  taxonomy = "Mlstr_area",
  vocabulary,
  term
)
}
\arguments{
\item{tibble}{Tibble to be annotated.}

\item{variables}{A character vector of variable names to be annotated. If NULL or empty, all
the columns of the tibble will be annotated.}

\item{taxonomy}{The taxonomy to which the vocabulary belongs. If NULL, the annotation is a simple
attribute (i.e. without a taxonomy reference).}

\item{vocabulary}{The vocabulary to which the term belongs.}

\item{term}{The term to apply. If NULL, the annotation will be deleted.}
}
\value{
The annotated tibble
}
\description{
Deprecated: use \link{dictionary.annotate} instead.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
cqx <- opal.table_get(o, "CPTP", "Cag_coreqx")
cqx <- dictionary.annotate(cqx, 
  variables = c("A_SDC_EDU_LEVEL", "A_SDC_EDU_LEVEL_AGE"), 
  taxonomy = "Mlstr_area", 
  vocabulary = "Sociodemographic_economic_characteristics", 
  term = "Education")
opal.logout(o)
}
}
