% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.file.R
\name{opal.file_cp}
\alias{opal.file_cp}
\title{Copy a file}
\usage{
opal.file_cp(opal, source, destination)
}
\arguments{
\item{opal}{Opal object.}

\item{source}{Path to the file in the Opal file system.}

\item{destination}{New path to the file in the Opal file system.}
}
\description{
Copy a file or a folder to another location in the Opal file system.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
# copy a file to another folder
opal.file_cp(o, '/home/administrator/export/some-data.csv', '/home/userx/deliverables')
# copy recursively a folder to another folder
opal.file_cp(o, '/home/administrator/export', '/home/userx/deliverables')
opal.logout(o)
}
}
\seealso{
Other file functions: 
\code{\link{opal.file_download}()},
\code{\link{opal.file_ls}()},
\code{\link{opal.file_mkdir_tmp}()},
\code{\link{opal.file_mkdir}()},
\code{\link{opal.file_mv}()},
\code{\link{opal.file_read}()},
\code{\link{opal.file_rm}()},
\code{\link{opal.file_upload}()},
\code{\link{opal.file_write}()},
\code{\link{opal.file}()}
}
\concept{file functions}
