% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.admin.R
\name{oadmin.install_github_package}
\alias{oadmin.install_github_package}
\title{Install a package from GitHub}
\usage{
oadmin.install_github_package(
  opal,
  pkg,
  username = getOption("github.user"),
  ref = "master"
)
}
\arguments{
\item{opal}{Opal object or list of opal objects.}

\item{pkg}{Package name.}

\item{username}{GitHub user or organization name.}

\item{ref}{Desired git reference. Could be a commit, tag, or branch name. Defaults to "master".}
}
\description{
Install a package from a source repository on GitHub.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
oadmin.install_github_package(o, 'opalr', 'obiba')
opal.logout(o)
}
}
\seealso{
Other administration functions: 
\code{\link{oadmin.install_bioconductor_package}()},
\code{\link{oadmin.install_devtools}()},
\code{\link{oadmin.install_local_package}()},
\code{\link{oadmin.install_package}()},
\code{\link{oadmin.installed_devtools}()},
\code{\link{oadmin.installed_packages}()},
\code{\link{oadmin.installed_package}()},
\code{\link{oadmin.package_description}()},
\code{\link{oadmin.remove_package}()}
}
\concept{administration functions}
