% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.table.R
\name{opal.table_perm_add}
\alias{opal.table_perm_add}
\title{Add or update a permission on a table}
\usage{
opal.table_perm_add(opal, project, table, subject, type = "user", permission)
}
\arguments{
\item{opal}{Opal connection object.}

\item{project}{Project name where the table will be located.}

\item{table}{Destination table name.}

\item{subject}{A vector of subject identifiers: user names or group names (depending on the type).}

\item{type}{The type of subject: user (default) or group.}

\item{permission}{The permission to apply: view, view-values, edit, edit-values, administrate. The 'view' permission
is suitable for DataSHIELD operations.}
}
\description{
Add or update a permission on a table.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
opal.table_perm_add(o, 'CNSIM', 'CNSIM1', c('andrei', 'valentina'), 'user', 'view')
opal.table_perm(o, 'CNSIM', 'CNSIM1')
opal.table_perm_delete(o, 'CNSIM', 'CNSIM1', c('andrei', 'valentina'), 'user')
opal.logout(o)
}
}
