% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.table.R
\name{opal.table_dictionary_update}
\alias{opal.table_dictionary_update}
\title{Update the dictionary of a Opal table}
\usage{
opal.table_dictionary_update(
  opal,
  project,
  table,
  variables,
  categories = NULL
)
}
\arguments{
\item{opal}{Opal connection object.}

\item{project}{Project name where the table will be located.}

\item{table}{Destination table name.}

\item{variables}{A data frame with one row per variable (column name) and then one column per property/attribute (Opal Excel format).}

\item{categories}{A data frame with one row per category (columns variable and name) and then column per property/attribute (Opal Excel format). If there are
no categories, this parameter is optional.}
}
\description{
Directly update the dictionary of a Opal table with the provided dictionary.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
variables <- tibble::tribble(
  ~name, ~valueType, ~`label:en`,  ~`Namespace::Name`, ~unit, ~repeatable, ~index,
  "mpg", "decimal", "Mpg label",  "Value1", "years", 0, 1,
  "cyl", "decimal", "Cyl label",  "Value2", "kg/m2", 0, 2,
  "disp", "decimal", "Disp label", NA, NA, 1, 3
)
categories <- tibble::tribble(
  ~variable, ~name, ~missing, ~`label:en`, ~`label:fr`,
  "cyl", "4", 0, "Four", "Quatre",
  "cyl", "6", 0, "Six", "Six",
  "cyl", "8", 1, "Height", "Huit"
)
opal.table_dictionary_update(o, "test", "mtcars", variables, categories)
opal.logout(o)
}
}
\seealso{
Other table functions: 
\code{\link{opal.table_create}()},
\code{\link{opal.table_delete}()},
\code{\link{opal.table_dictionary_get}()},
\code{\link{opal.table_exists}()},
\code{\link{opal.table_export}()},
\code{\link{opal.table_get}()},
\code{\link{opal.table_import}()},
\code{\link{opal.table_perm_add}()},
\code{\link{opal.table_perm_delete}()},
\code{\link{opal.table_perm}()},
\code{\link{opal.table_save}()},
\code{\link{opal.table_truncate}()}
}
\concept{table functions}
