% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.users.R
\name{oadmin.user_enable}
\alias{oadmin.user_enable}
\title{Enable a user}
\usage{
oadmin.user_enable(opal, name, enabled = TRUE)
}
\arguments{
\item{opal}{Opal object.}

\item{name}{User name}

\item{enabled}{Logical to enable a user.}
}
\description{
Enable or disable a user from Opal internal users registry.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
pwd <- oadmin.user_add(o, "foo", groups = c("datashield", "CNSIM"))
oadmin.user_enable(o, "foo", enabled = FALSE)
opal.logout(o)
}
}
\seealso{
Other user functions: 
\code{\link{oadmin.user_add}()},
\code{\link{oadmin.user_delete}()},
\code{\link{oadmin.user_exists}()},
\code{\link{oadmin.user_profile_delete}()},
\code{\link{oadmin.user_profiles}()},
\code{\link{oadmin.user_reset_password}()},
\code{\link{oadmin.users}()}
}
\concept{user functions}
