% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.token.R
\name{opal.token_renew}
\alias{opal.token_renew}
\title{Renew an inactive personal access token}
\usage{
opal.token_renew(opal, name)
}
\arguments{
\item{opal}{Opal object.}

\item{name}{Name of the token}
}
\description{
Renew an inactive personal access token after it has been marked as being inactive. Like for the other token functions, 
this operation requires the user to authenticate with username/password credentials.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
opal.token_renew(o, 'sql-1')
opal.logout(o)
}
}
\seealso{
Other token functions: 
\code{\link{opal.token_datashield_create}()},
\code{\link{opal.token_delete}()},
\code{\link{opal.token_r_create}()},
\code{\link{opal.token_sql_create}()},
\code{\link{opal.tokens}()},
\code{\link{opal.token}()}
}
\concept{token functions}
