/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.lang.english;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import opennlp.maxent.MaxentModel;
import opennlp.maxent.io.SuffixSensitiveGISModelReader;
import opennlp.tools.lang.english.CharacterEnum;
import opennlp.tools.namefind.NameContextGenerator;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.parser.Parse;
import opennlp.tools.util.Span;

public class NameFinder
extends NameFinderME {
    public static String[] NAME_TYPES = new String[]{"person", "organization", "location", "date", "time", "percentage", "money"};

    public NameFinder(MaxentModel mod) {
        super(mod);
    }

    public NameFinder(MaxentModel mod, NameContextGenerator cg) {
        super(mod, cg);
    }

    public NameFinder(MaxentModel mod, NameContextGenerator cg, int beamSize) {
        super(mod, cg, beamSize);
    }

    public static Span[] tokenizeToSpans(String s) {
        CharacterEnum charType;
        CharacterEnum state = charType = CharacterEnum.WHITESPACE;
        ArrayList<Span> tokens = new ArrayList<Span>();
        int sl = s.length();
        int start = -1;
        char pc = '\u0000';
        for (int ci = 0; ci < sl; ++ci) {
            char c = s.charAt(ci);
            charType = Character.isWhitespace(c) ? CharacterEnum.WHITESPACE : (Character.isLetter(c) ? CharacterEnum.ALPHABETIC : (Character.isDigit(c) ? CharacterEnum.NUMERIC : CharacterEnum.OTHER));
            if (state == CharacterEnum.WHITESPACE) {
                if (charType != CharacterEnum.WHITESPACE) {
                    start = ci;
                }
            } else if (charType != state || charType == CharacterEnum.OTHER && c != pc) {
                tokens.add(new Span(start, ci));
                start = ci;
            }
            state = charType;
            pc = c;
        }
        if (charType != CharacterEnum.WHITESPACE) {
            tokens.add(new Span(start, sl));
        }
        return tokens.toArray(new Span[tokens.size()]);
    }

    public static String[] spansToStrings(Span[] spans, String s) {
        String[] tokens = new String[spans.length];
        int sl = spans.length;
        for (int si = 0; si < sl; ++si) {
            tokens[si] = s.substring(spans[si].getStart(), spans[si].getEnd());
        }
        return tokens;
    }

    public static String[] tokenize(String s) {
        return NameFinder.spansToStrings(NameFinder.tokenizeToSpans(s), s);
    }

    private static void addNames(String tag, List names, Parse[] tokens) {
        int nn = names.size();
        for (int ni = 0; ni < nn; ++ni) {
            Parse[] grandKids;
            Parse endToken;
            Span nameTokenSpan = (Span)names.get(ni);
            Parse startToken = tokens[nameTokenSpan.getStart()];
            Parse commonParent = startToken.getCommonParent(endToken = tokens[nameTokenSpan.getEnd()]);
            if (commonParent == null) continue;
            Span nameSpan = new Span(startToken.getSpan().getStart(), endToken.getSpan().getEnd());
            if (nameSpan.equals(commonParent.getSpan())) {
                commonParent.insert(new Parse(commonParent.getText(), nameSpan, tag, 1.0));
                continue;
            }
            Parse[] kids = commonParent.getChildren();
            boolean crossingKids = false;
            int kn = kids.length;
            for (int ki = 0; ki < kn; ++ki) {
                if (!nameSpan.crosses(kids[ki].getSpan())) continue;
                crossingKids = true;
            }
            if (!crossingKids) {
                commonParent.insert(new Parse(commonParent.getText(), nameSpan, tag, 1.0));
                continue;
            }
            if (!commonParent.getType().equals("NP") || (grandKids = kids[0].getChildren()).length <= 1 || !nameSpan.contains(grandKids[grandKids.length - 1].getSpan())) continue;
            commonParent.insert(new Parse(commonParent.getText(), commonParent.getSpan(), tag, 1.0));
        }
    }

    private static Map[] createPrevTokenMaps(NameFinder[] finders) {
        Map[] prevTokenMaps = new HashMap[finders.length];
        int fl = finders.length;
        for (int fi = 0; fi < fl; ++fi) {
            prevTokenMaps[fi] = new HashMap();
        }
        return prevTokenMaps;
    }

    private static void clearPrevTokenMaps(Map[] prevTokenMaps) {
        int ml = prevTokenMaps.length;
        for (int mi = 0; mi < ml; ++mi) {
            prevTokenMaps[mi].clear();
        }
    }

    private static void updatePrevTokenMaps(Map[] prevTokenMaps, Object[] tokens, String[][] finderTags) {
        int ml = prevTokenMaps.length;
        for (int mi = 0; mi < ml; ++mi) {
            int tn = tokens.length;
            for (int ti = 0; ti < tn; ++ti) {
                prevTokenMaps[mi].put(tokens[ti], finderTags[mi][ti]);
            }
        }
    }

    private static void processParse(NameFinder[] finders, String[] tags, BufferedReader input) throws IOException {
        String[][] finderTags = new String[finders.length][];
        Map[] prevTokenMaps = NameFinder.createPrevTokenMaps(finders);
        String line = input.readLine();
        while (null != line) {
            if (line.equals("")) {
                System.out.println();
                NameFinder.clearPrevTokenMaps(prevTokenMaps);
            } else {
                int fi;
                Parse p = Parse.parseParse(line);
                Object[] tokens = p.getTagNodes();
                int fl = finders.length;
                for (fi = 0; fi < fl; ++fi) {
                    finderTags[fi] = finders[fi].find(tokens, prevTokenMaps[fi]);
                }
                NameFinder.updatePrevTokenMaps(prevTokenMaps, tokens, finderTags);
                fl = finders.length;
                for (fi = 0; fi < fl; ++fi) {
                    int start = -1;
                    ArrayList<Span> names = new ArrayList<Span>(5);
                    int tl = tokens.length;
                    for (int ti = 0; ti < tl; ++ti) {
                        if (finderTags[fi][ti].equals("start") || finderTags[fi][ti].equals("other")) {
                            if (start != -1) {
                                names.add(new Span(start, ti - 1));
                            }
                            start = -1;
                        }
                        if (!finderTags[fi][ti].equals("start")) continue;
                        start = ti;
                    }
                    if (start != -1) {
                        names.add(new Span(start, tokens.length - 1));
                    }
                    NameFinder.addNames(tags[fi], names, (Parse[])tokens);
                }
                p.show();
            }
            line = input.readLine();
        }
    }

    private static void processText(NameFinder[] finders, String[] tags, BufferedReader input) throws IOException {
        String[][] finderTags = new String[finders.length][];
        Map[] prevTokenMaps = NameFinder.createPrevTokenMaps(finders);
        String line = input.readLine();
        while (null != line) {
            if (line.equals("")) {
                NameFinder.clearPrevTokenMaps(prevTokenMaps);
                System.out.println();
            } else {
                int fi;
                Span[] spans = NameFinder.tokenizeToSpans(line);
                Object[] tokens = NameFinder.spansToStrings(spans, line);
                int fl = finders.length;
                for (fi = 0; fi < fl; ++fi) {
                    finderTags[fi] = finders[fi].find(tokens, prevTokenMaps[fi]);
                }
                NameFinder.updatePrevTokenMaps(prevTokenMaps, tokens, finderTags);
                int tl = tokens.length;
                for (int ti = 0; ti < tl; ++ti) {
                    int fi2;
                    int fl2 = finders.length;
                    for (fi2 = 0; fi2 < fl2; ++fi2) {
                        if (ti == 0 || !finderTags[fi2][ti].equals("start") && !finderTags[fi2][ti].equals("other") || !finderTags[fi2][ti - 1].equals("start") && !finderTags[fi2][ti - 1].equals("cont")) continue;
                        System.out.print("</" + tags[fi2] + ">");
                    }
                    if (ti > 0 && spans[ti - 1].getEnd() < spans[ti].getStart()) {
                        System.out.print(line.substring(spans[ti - 1].getEnd(), spans[ti].getStart()));
                    }
                    fl2 = finders.length;
                    for (fi2 = 0; fi2 < fl2; ++fi2) {
                        if (!finderTags[fi2][ti].equals("start")) continue;
                        System.out.print("<" + tags[fi2] + ">");
                    }
                    System.out.print((String)tokens[ti]);
                }
                if (tokens.length != 0) {
                    fl = finders.length;
                    for (fi = 0; fi < fl; ++fi) {
                        if (!finderTags[fi][tokens.length - 1].equals("start") && !finderTags[fi][tokens.length - 1].equals("cont")) continue;
                        System.out.print("</" + tags[fi] + ">");
                    }
                }
                if (tokens.length != 0 && spans[tokens.length - 1].getEnd() < line.length()) {
                    System.out.print(line.substring(spans[tokens.length - 1].getEnd()));
                }
                System.out.println();
            }
            line = input.readLine();
        }
    }

    public static void main(String[] args) throws IOException {
        int ai;
        if (args.length == 0) {
            System.err.println("Usage NameFinder -[parse] model1 model2 ... modelN < sentences");
            System.err.println(" -parse: Use this option to find names on parsed input.  Un-tokenized sentence text is the default.");
            System.exit(1);
        }
        boolean parsedInput = false;
        for (ai = 0; args[ai].startsWith("-") && ai < args.length; ++ai) {
            if (args[ai].equals("-parse")) {
                parsedInput = true;
                continue;
            }
            System.err.println("Ignoring unknown option " + args[ai]);
        }
        NameFinder[] finders = new NameFinder[args.length - ai];
        String[] names = new String[args.length - ai];
        int fi = 0;
        while (ai < args.length) {
            String modelName = args[ai];
            finders[fi] = new NameFinder((MaxentModel)new SuffixSensitiveGISModelReader(new File(modelName)).getModel());
            int nameStart = modelName.lastIndexOf(System.getProperty("file.separator")) + 1;
            int nameEnd = modelName.indexOf(46, nameStart);
            if (nameEnd == -1) {
                nameEnd = modelName.length();
            }
            names[fi] = modelName.substring(nameStart, nameEnd);
            ++ai;
            ++fi;
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        if (parsedInput) {
            NameFinder.processParse(finders, names, in);
        } else {
            NameFinder.processText(finders, names, in);
        }
    }
}

