/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import opennlp.tools.namefind.NameContextGenerator;
import opennlp.tools.util.Cache;
import opennlp.tools.util.Sequence;

public class DefaultNameContextGenerator
implements NameContextGenerator {
    private Pattern lowercase;
    private Pattern twoDigits;
    private Pattern fourDigits;
    private Pattern containsNumber;
    private Pattern containsLetter;
    private Pattern containsHyphens;
    private Pattern containsBackslash;
    private Pattern containsComma;
    private Pattern containsPeriod;
    private Pattern allCaps;
    private Pattern capPeriod;
    private Pattern initialCap;
    private Cache contextsCache;
    private Object wordsKey;
    private int pi = -1;
    private List prevStaticFeatures;

    public DefaultNameContextGenerator() {
        this(0);
    }

    public DefaultNameContextGenerator(int cacheSize) {
        this.initPatterns();
        if (cacheSize > 0) {
            this.contextsCache = new Cache(cacheSize);
        }
    }

    private void initPatterns() {
        this.lowercase = Pattern.compile("^[a-z]+$");
        this.twoDigits = Pattern.compile("^[0-9][0-9]$");
        this.fourDigits = Pattern.compile("^[0-9][0-9][0-9][0-9]$");
        this.containsNumber = Pattern.compile("[0-9]");
        this.containsLetter = Pattern.compile("[a-zA-Z]");
        this.containsHyphens = Pattern.compile("-");
        this.containsBackslash = Pattern.compile("/");
        this.containsComma = Pattern.compile(",");
        this.containsPeriod = Pattern.compile("\\.");
        this.allCaps = Pattern.compile("^[A-Z]+$");
        this.capPeriod = Pattern.compile("^[A-Z]\\.$");
        this.initialCap = Pattern.compile("^[A-Z]");
    }

    public String[] getContext(Object o) {
        Object[] data = (Object[])o;
        return this.getContext((int)((Integer)data[0]), (List)data[1], (List)data[2], (Map)data[3]);
    }

    public String[] getContext(int index, List sequence, Sequence s, Object[] additionalContext) {
        return this.getContext(index, sequence, s.getOutcomes(), (Map)additionalContext[0]);
    }

    public String[] getContext(int i, List toks, List preds, Map prevTags) {
        return this.getContext(i, toks.toArray(), preds.toArray(new String[preds.size()]), prevTags);
    }

    public String[] getContext(int index, Object[] sequence, String[] priorDecisions, Object[] additionalContext) {
        return this.getContext(index, sequence, priorDecisions, (Map)additionalContext[0]);
    }

    public String[] getContext(int i, Object[] toks, String[] preds, Map prevTags) {
        List features;
        String po = "other";
        String ppo = "other";
        if (i > 1) {
            ppo = preds[i - 2];
        }
        if (i > 0) {
            po = preds[i - 1];
        }
        String cacheKey = i + po + ppo;
        if (this.contextsCache != null) {
            if (this.wordsKey == toks) {
                String[] cachedContexts = (String[])this.contextsCache.get(cacheKey);
                if (cachedContexts != null) {
                    return cachedContexts;
                }
            } else {
                this.contextsCache.clear();
                this.wordsKey = toks;
            }
        }
        if (this.wordsKey == toks && i == this.pi) {
            features = this.prevStaticFeatures;
        } else {
            features = this.getStaticFeatures(toks, i, prevTags);
            this.pi = i;
            this.prevStaticFeatures = features;
        }
        int fn = features.size();
        String[] contexts = new String[fn + 4];
        for (int fi = 0; fi < fn; ++fi) {
            contexts[fi] = (String)features.get(fi);
        }
        contexts[fn] = "po=" + po;
        contexts[fn + 1] = "pow=" + po + toks[i];
        contexts[fn + 2] = "powf=" + po + this.wordFeature(toks[i].toString());
        contexts[fn + 3] = "ppo=" + ppo;
        if (this.contextsCache != null) {
            this.contextsCache.put(cacheKey, contexts);
        }
        return contexts;
    }

    private List getStaticFeatures(Object[] toks, int i, Map prevTags) {
        ArrayList<String> feats = new ArrayList<String>();
        feats.add("def");
        String w = toks[i].toString().toLowerCase();
        feats.add("w=" + w);
        String wf = this.wordFeature(toks[i].toString());
        feats.add("wf=" + wf);
        feats.add("w&wf=" + w + "," + wf);
        String pt = (String)prevTags.get(toks[i].toString());
        feats.add("pd=" + pt);
        if (i == 0) {
            feats.add("df=it");
        }
        if (i - 2 >= 0) {
            String ppw = toks[i - 2].toString().toLowerCase();
            feats.add("ppw=" + ppw);
            String ppwf = this.wordFeature(toks[i - 2].toString());
            feats.add("ppwf=" + ppwf);
            feats.add("ppw&f=" + ppw + "," + ppwf);
        } else {
            feats.add("ppw=BOS");
        }
        if (i == 0) {
            feats.add("pw=BOS");
            feats.add("pw=BOS,w=" + w);
            feats.add("pwf=BOS,wf" + wf);
        } else {
            String pw = toks[i - 1].toString().toLowerCase();
            feats.add("pw=" + pw);
            String pwf = this.wordFeature(toks[i - 1].toString());
            feats.add("pwf=" + pwf);
            feats.add("pw&f=" + pw + "," + pwf);
            feats.add("pw=" + pw + ",w=" + w);
            feats.add("pwf=" + pwf + ",wf=" + wf);
        }
        if (i + 1 >= toks.length) {
            feats.add("nw=EOS");
            feats.add("w=" + w + ",nw=EOS");
            feats.add("wf=" + wf + ",nw=EOS");
        } else {
            String nw = toks[i + 1].toString().toLowerCase();
            feats.add("nw=" + nw);
            String nwf = this.wordFeature(toks[i + 1].toString());
            feats.add("nwf=" + nwf);
            feats.add("nw&f=" + nw + "," + nwf);
            feats.add("w=" + w + ",nw=" + nw);
            feats.add("wf=" + wf + ",nwf=" + nwf);
        }
        if (i + 2 >= toks.length) {
            feats.add("nnw=EOS");
        } else {
            String nnw = toks[i + 2].toString().toLowerCase();
            feats.add("nnw=" + nnw);
            String nnwf = this.wordFeature(toks[i + 2].toString());
            feats.add("nnwf=" + nnwf);
            feats.add("nnw&f=" + nnw + "," + nnwf);
        }
        return feats;
    }

    private String wordFeature(String word) {
        String feat = this.lowercase.matcher(word).find() ? "lc" : (this.twoDigits.matcher(word).find() ? "2d" : (this.fourDigits.matcher(word).find() ? "4d" : (this.containsNumber.matcher(word).find() ? (this.containsLetter.matcher(word).find() ? "an" : (this.containsHyphens.matcher(word).find() ? "dd" : (this.containsBackslash.matcher(word).find() ? "ds" : (this.containsComma.matcher(word).find() ? "dc" : (this.containsPeriod.matcher(word).find() ? "dp" : "num"))))) : (this.allCaps.matcher(word).find() && word.length() == 1 ? "sc" : (this.allCaps.matcher(word).find() ? "ac" : (this.capPeriod.matcher(word).find() ? "cp" : (this.initialCap.matcher(word).find() ? "ic" : "other")))))));
        return feat;
    }
}

