/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ngram;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import opennlp.tools.ngram.Dictionary;
import opennlp.tools.ngram.NGram;
import opennlp.tools.ngram.NGramFactory;
import opennlp.tools.util.CountedNumberedSet;
import opennlp.tools.util.CountedSet;

public class MutableDictionary
extends Dictionary {
    List wordCounts;

    public MutableDictionary(int cutoff) {
        this.cutoff = cutoff;
        this.wordMap = new CountedNumberedSet();
        this.nGramFactory = new NGramFactory(this.wordMap);
        this.gramSet = new CountedSet();
        this.wordCounts = new ArrayList();
    }

    public MutableDictionary(String dictionaryFile, int cutoff) throws IOException {
        super(dictionaryFile);
        this.cutoff = cutoff;
    }

    protected void loadGrams(DataInputStream input) throws IOException {
        int numGrams = input.readInt();
        CountedSet cgramSet = new CountedSet(numGrams);
        for (int gi = 0; gi < numGrams; ++gi) {
            int gramLength = input.readInt();
            int[] words = new int[gramLength];
            for (int wi = 0; wi < gramLength; ++wi) {
                words[wi] = input.readInt();
            }
            cgramSet.setCount(new NGram(words), this.cutoff);
        }
        this.gramSet = cgramSet;
    }

    public void add(String[] words, int size, boolean unigrams) {
        int wi;
        int wn;
        ArrayList<String> gram = new ArrayList<String>(size);
        if (unigrams) {
            wn = words.length;
            for (wi = 0; wi < wn; ++wi) {
                this.wordMap.add(words[wi]);
            }
        }
        wn = words.length;
        for (wi = 0; wi < wn; ++wi) {
            gram.clear();
            gram.add(words[wi]);
            for (int gi = 2; gi <= size; ++gi) {
                if (wi + gi - 1 >= words.length) continue;
                gram.add(words[wi + gi - 1]);
                NGram ngram = this.nGramFactory.createNGram(gram);
                if (ngram != null) {
                    this.gramSet.add(ngram);
                    continue;
                }
                throw new NullPointerException();
            }
        }
    }

    public void persist(File file) throws IOException {
        DataOutputStream output = new DataOutputStream(new GZIPOutputStream(new FileOutputStream(file)));
        output.writeUTF(FILE_TYPE);
        System.err.println("pruning from " + this.wordMap.size());
        Iterator ki = this.wordMap.iterator();
        while (ki.hasNext()) {
            String key = (String)ki.next();
            if (((CountedNumberedSet)this.wordMap).getCount(key) >= this.cutoff) continue;
            ki.remove();
        }
        System.err.println("pruning to " + this.wordMap.size());
        output.writeInt(this.wordMap.size());
        for (String key : this.wordMap) {
            output.writeUTF(key);
            output.writeInt(this.wordMap.getIndex(key));
        }
        CountedSet cset = (CountedSet)this.gramSet;
        int gramCount = 0;
        for (NGram ngram : this.gramSet) {
            if (cset.getCount(ngram) < this.cutoff) continue;
            int[] words = ngram.getWords();
            output.writeInt(words.length);
            for (int wi = 0; wi < words.length; ++wi) {
                output.writeInt(words[wi]);
            }
            ++gramCount;
        }
        System.err.println("Wrote out " + gramCount + " n-grams");
        output.close();
    }
}

