/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import opennlp.maxent.ContextGenerator;
import opennlp.tools.ngram.Dictionary;
import opennlp.tools.parser.Parse;

public class BuildContextGenerator
implements ContextGenerator {
    private static final String EOS = "eos";
    private boolean zeroBackOff = false;
    private Dictionary dict;
    private String[] unigram;
    private String[] bigram;
    private String[] trigram;

    public BuildContextGenerator() {
    }

    public BuildContextGenerator(Dictionary dict) {
        this();
        this.dict = dict;
        this.unigram = new String[1];
        this.bigram = new String[2];
        this.trigram = new String[3];
    }

    public String[] getContext(Object o) {
        Object[] params = (Object[])o;
        return this.getContext((Parse[])params[0], (Integer)params[1]);
    }

    private String punct(Parse punct, int i) {
        StringBuffer feat = new StringBuffer(5);
        feat.append(i).append("=");
        feat.append(punct.getType());
        return feat.toString();
    }

    private String cons(Parse p, int i) {
        StringBuffer feat = new StringBuffer(20);
        feat.append(i).append("=");
        if (p != null) {
            if (i < 0) {
                feat.append(p.getLabel()).append("|");
            }
            feat.append(p.getType()).append("|").append(p.getHead().toString());
        } else {
            feat.append(EOS);
        }
        return feat.toString();
    }

    private String consbo(Parse p, int i) {
        StringBuffer feat = new StringBuffer(20);
        feat.append(i).append("*=");
        if (p != null) {
            if (i < 0) {
                feat.append(p.getLabel()).append("|");
            }
            feat.append(p.getType());
        } else {
            feat.append(EOS);
        }
        return feat.toString();
    }

    public String[] getContext(Parse[] constituents, int index) {
        Parse p;
        String punct_1;
        Iterator pi_1;
        String punct1;
        Iterator pi1;
        String punct12;
        Iterator pi12;
        String punct;
        Iterator pi;
        ArrayList<String> features = new ArrayList<String>(100);
        int ps = constituents.length;
        features.add("default");
        Parse p_2 = null;
        Parse p_1 = null;
        Parse p0 = null;
        Parse p1 = null;
        Parse p2 = null;
        Collection punct1s = null;
        Collection punct2s = null;
        Collection punct_1s = null;
        Collection punct_2s = null;
        if (index - 2 >= 0) {
            p_2 = constituents[index - 2];
        }
        if (index - 1 >= 0) {
            p_1 = constituents[index - 1];
            punct_2s = p_1.getPreviousPunctuationSet();
        }
        p0 = constituents[index];
        punct_1s = p0.getPreviousPunctuationSet();
        punct1s = p0.getNextPunctuationSet();
        if (index + 1 < ps) {
            p1 = constituents[index + 1];
            punct2s = p1.getNextPunctuationSet();
        }
        if (index + 2 < ps) {
            p2 = constituents[index + 2];
        }
        boolean u_2 = true;
        boolean u_1 = true;
        boolean u0 = true;
        boolean u1 = true;
        boolean u2 = true;
        boolean b_2_1 = true;
        boolean b_10 = true;
        boolean b01 = true;
        boolean b12 = true;
        boolean t_2_10 = true;
        boolean t_101 = true;
        boolean t012 = true;
        if (this.dict != null) {
            if (p_2 != null) {
                this.unigram[0] = p_2.getHead().toString();
                u_2 = this.dict.contains(this.unigram);
            }
            if (p2 != null) {
                this.unigram[0] = p2.getHead().toString();
                u2 = this.dict.contains(this.unigram);
            }
            this.unigram[0] = p0.getHead().toString();
            u0 = this.dict.contains(this.unigram);
            if (p_2 != null && p_1 != null) {
                this.bigram[0] = p_2.getHead().toString();
                this.bigram[1] = p_1.getHead().toString();
                b_2_1 = this.dict.contains(this.bigram);
                this.trigram[0] = p_2.getHead().toString();
                this.trigram[1] = p_1.getHead().toString();
                this.trigram[2] = p0.getHead().toString();
                t_2_10 = this.dict.contains(this.trigram);
            }
            if (p_1 != null && p1 != null) {
                this.trigram[0] = p_1.getHead().toString();
                this.trigram[1] = p0.getHead().toString();
                this.trigram[2] = p1.getHead().toString();
                t_101 = this.dict.contains(this.trigram);
            }
            if (p_1 != null) {
                this.unigram[0] = p_1.getHead().toString();
                u_1 = this.dict.contains(this.unigram);
                b_2_1 = b_2_1 && u_1;
                t_2_10 = t_2_10 && u_1;
                t_101 = t_101 && u_1;
                this.bigram[0] = p_1.getHead().toString();
                this.bigram[1] = p0.getHead().toString();
                b_10 = this.dict.contains(this.bigram);
            }
            if (p1 != null && p2 != null) {
                this.bigram[0] = p1.getHead().toString();
                this.bigram[1] = p2.getHead().toString();
                b12 = this.dict.contains(this.bigram);
                this.trigram[0] = p0.getHead().toString();
                this.trigram[1] = p1.getHead().toString();
                this.trigram[2] = p2.getHead().toString();
                t012 = this.dict.contains(this.trigram);
            }
            if (p1 != null) {
                this.unigram[0] = p1.getHead().toString();
                u1 = this.dict.contains(this.unigram);
                b12 = b12 && u1;
                t012 = t012 && u1;
                t_101 = t_101 && u1;
                this.bigram[0] = p0.getHead().toString();
                this.bigram[1] = p1.getHead().toString();
                b01 = this.dict.contains(this.bigram);
            }
        }
        String consp_2 = this.cons(p_2, -2);
        String consp_1 = this.cons(p_1, -1);
        String consp0 = this.cons(p0, 0);
        String consp1 = this.cons(p1, 1);
        String consp2 = this.cons(p2, 2);
        String consbop_2 = this.consbo(p_2, -2);
        String consbop_1 = this.consbo(p_1, -1);
        String consbop0 = this.consbo(p0, 0);
        String consbop1 = this.consbo(p1, 1);
        String consbop2 = this.consbo(p2, 2);
        if (u0) {
            features.add(consp0);
        }
        features.add(consbop0);
        if (u_2) {
            features.add(consp_2);
        }
        features.add(consbop_2);
        if (u_1) {
            features.add(consp_1);
        }
        features.add(consbop_1);
        if (u1) {
            features.add(consp1);
        }
        features.add(consbop1);
        if (u2) {
            features.add(consp2);
        }
        features.add(consbop2);
        if (punct1s != null) {
            pi = punct1s.iterator();
            while (pi.hasNext()) {
                punct = this.punct((Parse)pi.next(), 1);
                features.add(punct);
                if (u0) {
                    features.add(consp0 + "," + punct);
                }
                features.add(consbop0 + "," + punct);
                if (b01) {
                    features.add(consp0 + "," + punct + "," + consp1);
                }
                if (u1) {
                    features.add(consbop0 + "," + punct + "," + consp1);
                }
                if (u0) {
                    features.add(consp0 + "," + punct + "," + consbop1);
                }
                features.add(consbop0 + "," + punct + "," + consbop1);
            }
        } else {
            if (b01) {
                features.add(consp0 + "," + consp1);
            }
            if (u1) {
                features.add(consbop0 + "," + consp1);
            }
            if (u0) {
                features.add(consp0 + "," + consbop1);
            }
            features.add(consbop0 + "," + consbop1);
        }
        if (punct_1s != null) {
            pi = punct_1s.iterator();
            while (pi.hasNext()) {
                punct = this.punct((Parse)pi.next(), -1);
                features.add(punct);
                if (u0) {
                    features.add(punct + "," + consp0);
                }
                features.add(punct + "," + consbop0);
                if (b_10) {
                    features.add(consp_1 + "," + punct + "," + consp0);
                }
                if (u0) {
                    features.add(consbop_1 + "," + punct + "," + consp0);
                }
                if (u_1) {
                    features.add(consp_1 + "," + punct + "," + consbop0);
                }
                features.add(consbop_1 + "," + punct + "," + consbop0);
            }
        } else {
            if (b_10) {
                features.add(consp_1 + "," + consp0);
            }
            if (u0) {
                features.add(consbop_1 + "," + consp0);
            }
            if (u_1) {
                features.add(consp_1 + "," + consbop0);
            }
            features.add(consbop_1 + "," + consbop0);
        }
        if (punct2s != null) {
            String punct2;
            Iterator pi2;
            pi = punct2s.iterator();
            while (pi.hasNext()) {
                punct = this.punct((Parse)pi.next(), 2);
                features.add(punct);
            }
            if (punct1s != null) {
                pi2 = punct2s.iterator();
                while (pi2.hasNext()) {
                    punct2 = this.punct((Parse)pi2.next(), 2);
                    pi12 = punct1s.iterator();
                    while (pi12.hasNext()) {
                        punct12 = this.punct((Parse)pi12.next(), 1);
                        if (t012) {
                            features.add(consp0 + "," + punct12 + "," + consp1 + "," + punct2 + "," + consp2);
                        }
                        if (b12) {
                            features.add(consbop0 + "," + punct12 + "," + consp1 + "," + punct2 + "," + consp2);
                        }
                        if (u0 && u2) {
                            features.add(consp0 + "," + punct12 + "," + consbop1 + "," + punct2 + "," + consp2);
                        }
                        if (b01) {
                            features.add(consp0 + "," + punct12 + "," + consp1 + "," + punct2 + "," + consbop2);
                        }
                        if (u2) {
                            features.add(consbop0 + "," + punct12 + "," + consbop1 + "," + punct2 + "," + consp2);
                        }
                        if (u1) {
                            features.add(consbop0 + "," + punct12 + "," + consp1 + "," + punct2 + "," + consbop2);
                        }
                        if (u0) {
                            features.add(consp0 + "," + punct12 + "," + consbop1 + "," + punct2 + "," + consbop2);
                        }
                        features.add(consbop0 + "," + punct12 + "," + consbop1 + "," + punct2 + "," + consbop2);
                        if (!this.zeroBackOff) continue;
                        if (b01) {
                            features.add(consp0 + "," + punct12 + "," + consp1 + "," + punct2);
                        }
                        if (u1) {
                            features.add(consbop0 + "," + punct12 + "," + consp1 + "," + punct2);
                        }
                        if (u0) {
                            features.add(consp0 + "," + punct12 + "," + consbop1 + "," + punct2);
                        }
                        features.add(consbop0 + "," + punct12 + "," + consbop1 + "," + punct2);
                    }
                }
            } else {
                pi2 = punct2s.iterator();
                while (pi2.hasNext()) {
                    punct2 = this.punct((Parse)pi2.next(), 2);
                    if (t012) {
                        features.add(consp0 + "," + consp1 + "," + punct2 + "," + consp2);
                    }
                    if (b12) {
                        features.add(consbop0 + "," + consp1 + "," + punct2 + "," + consp2);
                    }
                    if (u0 && u2) {
                        features.add(consp0 + "," + consbop1 + "," + punct2 + "," + consp2);
                    }
                    if (b01) {
                        features.add(consp0 + "," + consp1 + "," + punct2 + "," + consbop2);
                    }
                    if (u2) {
                        features.add(consbop0 + "," + consbop1 + "," + punct2 + "," + consp2);
                    }
                    if (u1) {
                        features.add(consbop0 + "," + consp1 + "," + punct2 + "," + consbop2);
                    }
                    if (u0) {
                        features.add(consp0 + "," + consbop1 + "," + punct2 + "," + consbop2);
                    }
                    features.add(consbop0 + "," + consbop1 + "," + punct2 + "," + consbop2);
                    if (!this.zeroBackOff) continue;
                    if (b01) {
                        features.add(consp0 + "," + consp1 + "," + punct2);
                    }
                    if (u1) {
                        features.add(consbop0 + "," + consp1 + "," + punct2);
                    }
                    if (u0) {
                        features.add(consp0 + "," + consbop1 + "," + punct2);
                    }
                    features.add(consbop0 + "," + consbop1 + "," + punct2);
                }
            }
        } else if (punct1s != null) {
            pi1 = punct1s.iterator();
            while (pi1.hasNext()) {
                punct1 = this.punct((Parse)pi1.next(), 1);
                if (t012) {
                    features.add(consp0 + "," + punct1 + "," + consp1 + "," + consp2);
                }
                if (b12) {
                    features.add(consbop0 + "," + punct1 + "," + consp1 + "," + consp2);
                }
                if (u0 && u2) {
                    features.add(consp0 + "," + punct1 + "," + consbop1 + "," + consp2);
                }
                if (b01) {
                    features.add(consp0 + "," + punct1 + "," + consp1 + "," + consbop2);
                }
                if (u2) {
                    features.add(consbop0 + "," + punct1 + "," + consbop1 + "," + consp2);
                }
                if (u1) {
                    features.add(consbop0 + "," + punct1 + "," + consp1 + "," + consbop2);
                }
                if (u0) {
                    features.add(consp0 + "," + punct1 + "," + consbop1 + "," + consbop2);
                }
                features.add(consbop0 + "," + punct1 + "," + consbop1 + "," + consbop2);
            }
        } else {
            if (t012) {
                features.add(consp0 + "," + consp1 + "," + consp2);
            }
            if (b12) {
                features.add(consbop0 + "," + consp1 + "," + consp2);
            }
            if (u0 && u2) {
                features.add(consp0 + "," + consbop1 + "," + consp2);
            }
            if (b01) {
                features.add(consp0 + "," + consp1 + "," + consbop2);
            }
            if (u2) {
                features.add(consbop0 + "," + consbop1 + "," + consp2);
            }
            if (u1) {
                features.add(consbop0 + "," + consp1 + "," + consbop2);
            }
            if (u0) {
                features.add(consp0 + "," + consbop1 + "," + consbop2);
            }
            features.add(consbop0 + "," + consbop1 + "," + consbop2);
        }
        if (punct_2s != null) {
            String punct_2;
            Iterator pi_2;
            pi = punct_2s.iterator();
            while (pi.hasNext()) {
                punct = this.punct((Parse)pi.next(), -2);
                features.add(punct);
            }
            if (punct_1s != null) {
                pi_2 = punct_2s.iterator();
                while (pi_2.hasNext()) {
                    punct_2 = this.punct((Parse)pi_2.next(), -2);
                    Iterator pi_12 = punct_1s.iterator();
                    while (pi_12.hasNext()) {
                        String punct_12 = this.punct((Parse)pi_12.next(), -1);
                        if (t_2_10) {
                            features.add(consp_2 + "," + punct_2 + "," + consp_1 + "," + punct_12 + "," + consp0);
                        }
                        if (b_10) {
                            features.add(consbop_2 + "," + punct_2 + "," + consp_1 + "," + punct_12 + "," + consp0);
                        }
                        if (u_2 && u0) {
                            features.add(consp_2 + "," + punct_2 + "," + consbop_1 + "," + punct_12 + "," + consp0);
                        }
                        if (b_2_1) {
                            features.add(consp_2 + "," + punct_2 + "," + consp_1 + "," + punct_12 + "," + consbop0);
                        }
                        if (u0) {
                            features.add(consbop_2 + "," + punct_2 + "," + consbop_1 + "," + punct_12 + "," + consp0);
                        }
                        if (u_1) {
                            features.add(consbop_2 + "," + punct_2 + "," + consp_1 + "," + punct_12 + "," + consbop0);
                        }
                        if (u_2) {
                            features.add(consp_2 + "," + punct_2 + "," + consbop_1 + "," + punct_12 + "," + consbop0);
                        }
                        features.add(consbop_2 + "," + punct_2 + "," + consbop_1 + "," + punct_12 + "," + consbop0);
                        if (!this.zeroBackOff) continue;
                        if (b_10) {
                            features.add(punct_2 + "," + consp_1 + "," + punct_12 + "," + consp0);
                        }
                        if (u0) {
                            features.add(punct_2 + "," + consbop_1 + "," + punct_12 + "," + consp0);
                        }
                        if (u_1) {
                            features.add(punct_2 + "," + consp_1 + "," + punct_12 + "," + consbop0);
                        }
                        features.add(punct_2 + "," + consbop_1 + "," + punct_12 + "," + consbop0);
                    }
                }
            } else {
                pi_2 = punct_2s.iterator();
                while (pi_2.hasNext()) {
                    punct_2 = this.punct((Parse)pi_2.next(), -2);
                    if (t_2_10) {
                        features.add(consp_2 + "," + punct_2 + "," + consp_1 + "," + consp0);
                    }
                    if (b_10) {
                        features.add(consbop_2 + "," + punct_2 + "," + consp_1 + "," + consp0);
                    }
                    if (u_2 && u0) {
                        features.add(consp_2 + "," + punct_2 + "," + consbop_1 + "," + consp0);
                    }
                    if (b_2_1) {
                        features.add(consp_2 + "," + punct_2 + "," + consp_1 + "," + consbop0);
                    }
                    if (u0) {
                        features.add(consbop_2 + "," + punct_2 + "," + consbop_1 + "," + consp0);
                    }
                    if (u_1) {
                        features.add(consbop_2 + "," + punct_2 + "," + consp_1 + "," + consbop0);
                    }
                    if (u_2) {
                        features.add(consp_2 + "," + punct_2 + "," + consbop_1 + "," + consbop0);
                    }
                    features.add(consbop_2 + "," + punct_2 + "," + consbop_1 + "," + consbop0);
                    if (!this.zeroBackOff) continue;
                    if (b_10) {
                        features.add(punct_2 + "," + consp_1 + "," + consp0);
                    }
                    if (u0) {
                        features.add(punct_2 + "," + consbop_1 + "," + consp0);
                    }
                    if (u_1) {
                        features.add(punct_2 + "," + consp_1 + "," + consbop0);
                    }
                    features.add(punct_2 + "," + consbop_1 + "," + consbop0);
                }
            }
        } else if (punct_1s != null) {
            pi_1 = punct_1s.iterator();
            while (pi_1.hasNext()) {
                punct_1 = this.punct((Parse)pi_1.next(), -1);
                if (t_2_10) {
                    features.add(consp_2 + "," + consp_1 + "," + punct_1 + "," + consp0);
                }
                if (b_10) {
                    features.add(consbop_2 + "," + consp_1 + "," + punct_1 + "," + consp0);
                }
                if (u_2 && u0) {
                    features.add(consp_2 + "," + consbop_1 + "," + punct_1 + "," + consp0);
                }
                if (b_2_1) {
                    features.add(consp_2 + "," + consp_1 + "," + punct_1 + "," + consbop0);
                }
                if (u0) {
                    features.add(consbop_2 + "," + consbop_1 + "," + punct_1 + "," + consp0);
                }
                if (u_1) {
                    features.add(consbop_2 + "," + consp_1 + "," + punct_1 + "," + consbop0);
                }
                if (u_2) {
                    features.add(consp_2 + "," + consbop_1 + "," + punct_1 + "," + consbop0);
                }
                features.add(consbop_2 + "," + consbop_1 + "," + punct_1 + "," + consbop0);
            }
        } else {
            if (t_2_10) {
                features.add(consp_2 + "," + consp_1 + "," + consp0);
            }
            if (b_10) {
                features.add(consbop_2 + "," + consp_1 + "," + consp0);
            }
            if (u_2 && u0) {
                features.add(consp_2 + "," + consbop_1 + "," + consp0);
            }
            if (b_2_1) {
                features.add(consp_2 + "," + consp_1 + "," + consbop0);
            }
            if (u0) {
                features.add(consbop_2 + "," + consbop_1 + "," + consp0);
            }
            if (u_1) {
                features.add(consbop_2 + "," + consp_1 + "," + consbop0);
            }
            if (u_2) {
                features.add(consp_2 + "," + consbop_1 + "," + consbop0);
            }
            features.add(consbop_2 + "," + consbop_1 + "," + consbop0);
        }
        if (punct_1s != null) {
            if (punct1s != null) {
                pi_1 = punct_1s.iterator();
                while (pi_1.hasNext()) {
                    punct_1 = this.punct((Parse)pi_1.next(), -1);
                    pi12 = punct1s.iterator();
                    while (pi12.hasNext()) {
                        punct12 = this.punct((Parse)pi12.next(), 1);
                        if (t_101) {
                            features.add(consp_1 + "," + punct_1 + "," + consp0 + "," + punct12 + "," + consp1);
                        }
                        if (b01) {
                            features.add(consbop_1 + "," + punct_1 + "," + consp0 + "," + punct12 + "," + consp1);
                        }
                        if (u_1 && u1) {
                            features.add(consp_1 + "," + punct_1 + "," + consbop0 + "," + punct12 + "," + consp1);
                        }
                        if (b_10) {
                            features.add(consp_1 + "," + punct_1 + "," + consp0 + "," + punct12 + "," + consbop1);
                        }
                        if (u1) {
                            features.add(consbop_1 + "," + punct_1 + "," + consbop0 + "," + punct12 + "," + consp1);
                        }
                        if (u0) {
                            features.add(consbop_1 + "," + punct_1 + "," + consp0 + "," + punct12 + "," + consbop1);
                        }
                        if (u_1) {
                            features.add(consp_1 + "," + punct_1 + "," + consbop0 + "," + punct12 + "," + consbop1);
                        }
                        features.add(consbop_1 + "," + punct_1 + "," + consbop0 + "," + punct12 + "," + consbop1);
                        if (!this.zeroBackOff) continue;
                        if (b_10) {
                            features.add(consp_1 + "," + punct_1 + "," + consp0 + "," + punct12);
                        }
                        if (u0) {
                            features.add(consbop_1 + "," + punct_1 + "," + consp0 + "," + punct12);
                        }
                        if (u_1) {
                            features.add(consp_1 + "," + punct_1 + "," + consbop0 + "," + punct12);
                        }
                        features.add(consbop_1 + "," + punct_1 + "," + consbop0 + "," + punct12);
                        if (b01) {
                            features.add(punct_1 + "," + consp0 + "," + punct12 + "," + consp1);
                        }
                        if (u1) {
                            features.add(punct_1 + "," + consbop0 + "," + punct12 + "," + consp1);
                        }
                        if (u0) {
                            features.add(punct_1 + "," + consp0 + "," + punct12 + "," + consbop1);
                        }
                        features.add(punct_1 + "," + consbop0 + "," + punct12 + "," + consbop1);
                    }
                }
            } else {
                pi_1 = punct_1s.iterator();
                while (pi_1.hasNext()) {
                    punct_1 = this.punct((Parse)pi_1.next(), -1);
                    if (t_101) {
                        features.add(consp_1 + "," + punct_1 + "," + consp0 + "," + consp1);
                    }
                    if (b01) {
                        features.add(consbop_1 + "," + punct_1 + "," + consp0 + "," + consp1);
                    }
                    if (u_1 && u1) {
                        features.add(consp_1 + "," + punct_1 + "," + consbop0 + "," + consp1);
                    }
                    if (u0) {
                        features.add(consp_1 + "," + punct_1 + "," + consp0 + "," + consbop1);
                    }
                    if (u1) {
                        features.add(consbop_1 + "," + punct_1 + "," + consbop0 + "," + consp1);
                    }
                    if (u0) {
                        features.add(consbop_1 + "," + punct_1 + "," + consp0 + "," + consbop1);
                    }
                    if (u_1) {
                        features.add(consp_1 + "," + punct_1 + "," + consbop0 + "," + consbop1);
                    }
                    features.add(consbop_1 + "," + punct_1 + "," + consbop0 + "," + consbop1);
                    if (!this.zeroBackOff) continue;
                    if (b01) {
                        features.add(punct_1 + "," + consp0 + "," + consp1);
                    }
                    if (u1) {
                        features.add(punct_1 + "," + consbop0 + "," + consp1);
                    }
                    if (u0) {
                        features.add(punct_1 + "," + consp0 + "," + consbop1);
                    }
                    features.add(punct_1 + "," + consbop0 + "," + consbop1);
                }
            }
        } else if (punct1s != null) {
            pi1 = punct1s.iterator();
            while (pi1.hasNext()) {
                punct1 = this.punct((Parse)pi1.next(), 1);
                if (t_101) {
                    features.add(consp_1 + "," + consp0 + "," + punct1 + "," + consp1);
                }
                if (b01) {
                    features.add(consbop_1 + "," + consp0 + "," + punct1 + "," + consp1);
                }
                if (u_1 && u1) {
                    features.add(consp_1 + "," + consbop0 + "," + punct1 + "," + consp1);
                }
                if (b_10) {
                    features.add(consp_1 + "," + consp0 + "," + punct1 + "," + consbop1);
                }
                if (u1) {
                    features.add(consbop_1 + "," + consbop0 + "," + punct1 + "," + consp1);
                }
                if (u0) {
                    features.add(consbop_1 + "," + consp0 + "," + punct1 + "," + consbop1);
                }
                if (u_1) {
                    features.add(consp_1 + "," + consbop0 + "," + punct1 + "," + consbop1);
                }
                features.add(consbop_1 + "," + consbop0 + "," + punct1 + "," + consbop1);
                if (!this.zeroBackOff) continue;
                if (b_10) {
                    features.add(consp_1 + "," + consp0 + "," + punct1);
                }
                if (u0) {
                    features.add(consbop_1 + "," + consp0 + "," + punct1);
                }
                if (u_1) {
                    features.add(consp_1 + "," + consbop0 + "," + punct1);
                }
                features.add(consbop_1 + "," + consbop0 + "," + punct1);
            }
        } else {
            if (t_101) {
                features.add(consp_1 + "," + consp0 + "," + consp1);
            }
            if (b01) {
                features.add(consbop_1 + "," + consp0 + "," + consp1);
            }
            if (u_1 && u1) {
                features.add(consp_1 + "," + consbop0 + "," + consp1);
            }
            if (b_10) {
                features.add(consp_1 + "," + consp0 + "," + consbop1);
            }
            if (u1) {
                features.add(consbop_1 + "," + consbop0 + "," + consp1);
            }
            if (u0) {
                features.add(consbop_1 + "," + consp0 + "," + consbop1);
            }
            if (u_1) {
                features.add(consp_1 + "," + consbop0 + "," + consbop1);
            }
            features.add(consbop_1 + "," + consbop0 + "," + consbop1);
        }
        String p0Word = p0.toString();
        if (p0Word.equals("-RRB-")) {
            for (int pi2 = index - 1; pi2 >= 0; --pi2) {
                p = constituents[pi2];
                if (p.toString().equals("-LRB-")) {
                    features.add("bracketsmatch");
                    break;
                }
                if (p.getLabel().startsWith("S-")) break;
            }
        }
        if (p0Word.equals("-RCB-")) {
            for (int pi3 = index - 1; pi3 >= 0; --pi3) {
                p = constituents[pi3];
                if (p.toString().equals("-LCB-")) {
                    features.add("bracketsmatch");
                    break;
                }
                if (p.getLabel().startsWith("S-")) break;
            }
        }
        if (p0Word.equals("''")) {
            for (int pi4 = index - 1; pi4 >= 0; --pi4) {
                p = constituents[pi4];
                if (p.toString().equals("``")) {
                    features.add("quotesmatch");
                    break;
                }
                if (p.getLabel().startsWith("S-")) break;
            }
        }
        if (p0Word.equals("'")) {
            for (int pi5 = index - 1; pi5 >= 0; --pi5) {
                p = constituents[pi5];
                if (p.toString().equals("`")) {
                    features.add("quotesmatch");
                    break;
                }
                if (p.getLabel().startsWith("S-")) break;
            }
        }
        if (p0Word.equals(",")) {
            for (int pi6 = index - 1; pi6 >= 0; --pi6) {
                p = constituents[pi6];
                if (p.toString().equals(",")) {
                    features.add("iscomma");
                    break;
                }
                if (p.getLabel().startsWith("S-")) break;
            }
        }
        if (p0Word.equals(".") && index == ps - 1) {
            for (int pi7 = index - 1; pi7 >= 0; --pi7) {
                p = constituents[pi7];
                if (!p.getLabel().startsWith("S-")) continue;
                if (pi7 != 0) break;
                features.add("endofsentence");
                break;
            }
        }
        return features.toArray(new String[features.size()]);
    }
}

