/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import opennlp.maxent.ContextGenerator;
import opennlp.tools.parser.Parse;

public class CheckContextGenerator
implements ContextGenerator {
    private static final String EOS = "eos";

    public String[] getContext(Object o) {
        Object[] params = (Object[])o;
        return this.getContext((Parse[])params[0], (String)params[1], (Integer)params[2], (Integer)params[3]);
    }

    private void surround(Parse p, int i, String type, Collection punctSet, List features) {
        StringBuffer feat = new StringBuffer(20);
        feat.append("s").append(i).append("=");
        if (punctSet != null) {
            for (Parse punct : punctSet) {
                if (p != null) {
                    feat.append(p.getHead().toString()).append("|").append(type).append("|").append(p.getHead().getType()).append("|").append(punct.getType());
                } else {
                    feat.append(type).append("|").append(EOS).append("|").append(punct.getType());
                }
                features.add(feat.toString());
                feat.setLength(0);
                feat.append("s").append(i).append("*=");
                if (p != null) {
                    feat.append(type).append("|").append(p.getHead().getType()).append("|").append(punct.getType());
                } else {
                    feat.append(type).append("|").append(EOS).append("|").append(punct.getType());
                }
                features.add(feat.toString());
                feat.setLength(0);
                feat.append("s").append(i).append("*=");
                feat.append(type).append("|").append(punct.getType());
                features.add(feat.toString());
            }
        } else {
            if (p != null) {
                feat.append(p.getHead().toString()).append("|").append(type).append("|").append(p.getHead().getType());
            } else {
                feat.append(type).append("|").append(EOS);
            }
            features.add(feat.toString());
            feat.setLength(0);
            feat.append("s").append(i).append("*=");
            if (p != null) {
                feat.append(type).append("|").append(p.getHead().getType());
            } else {
                feat.append(type).append("|").append(EOS);
            }
            features.add(feat.toString());
        }
    }

    private void checkcons(Parse p, String i, String type, List features) {
        StringBuffer feat = new StringBuffer(20);
        feat.append("c").append(i).append("=").append(p.getType()).append("|").append(p.getHead().toString()).append("|").append(type);
        features.add(feat.toString());
        feat.setLength(0);
        feat.append("c").append(i).append("*=").append(p.getType()).append("|").append(type);
        features.add(feat.toString());
    }

    private void checkcons(Parse p1, Parse p2, String type, List features) {
        StringBuffer feat = new StringBuffer(20);
        feat.append("cil=").append(type).append(",").append(p1.getType()).append("|").append(p1.getHead().toString()).append(",").append(p2.getType()).append("|").append(p2.getHead().toString());
        features.add(feat.toString());
        feat.setLength(0);
        feat.append("ci*l=").append(type).append(",").append(p1.getType()).append(",").append(p2.getType()).append("|").append(p2.getHead().toString());
        features.add(feat.toString());
        feat.setLength(0);
        feat.append("cil*=").append(type).append(",").append(p1.getType()).append("|").append(p1.getHead().toString()).append(",").append(p2.getType());
        features.add(feat.toString());
        feat.setLength(0);
        feat.append("ci*l*=").append(type).append(",").append(p1.getType()).append(",").append(p2.getType());
        features.add(feat.toString());
    }

    public String[] getContext(Parse[] constituents, String type, int start, int end) {
        int ps = constituents.length;
        ArrayList<String> features = new ArrayList<String>(100);
        features.add("default");
        Parse pstart = constituents[start];
        Parse pend = constituents[end];
        this.checkcons(pstart, "begin", type, features);
        this.checkcons(pend, "last", type, features);
        StringBuffer production = new StringBuffer(20);
        StringBuffer punctProduction = new StringBuffer(20);
        production.append("p=").append(type).append("->");
        punctProduction.append("pp=").append(type).append("->");
        for (int pi = start; pi < end; ++pi) {
            Parse p = constituents[pi];
            this.checkcons(p, pend, type, features);
            production.append(p.getType()).append(",");
            punctProduction.append(p.getType()).append(",");
            Collection nextPunct = p.getNextPunctuationSet();
            if (nextPunct == null) continue;
            for (Parse punct : nextPunct) {
                punctProduction.append(punct.getType()).append(",");
            }
        }
        production.append(pend.getType());
        punctProduction.append(pend.getType());
        features.add(production.toString());
        features.add(punctProduction.toString());
        Parse p_2 = null;
        Parse p_1 = null;
        Parse p1 = null;
        Parse p2 = null;
        Collection p1s = constituents[end].getNextPunctuationSet();
        Collection p2s = null;
        Collection p_1s = constituents[start].getPreviousPunctuationSet();
        Collection p_2s = null;
        if (start - 2 >= 0) {
            p_2 = constituents[start - 2];
        }
        if (start - 1 >= 0) {
            p_1 = constituents[start - 1];
            p_2s = p_1.getPreviousPunctuationSet();
        }
        if (end + 1 < ps) {
            p1 = constituents[end + 1];
            p2s = p1.getNextPunctuationSet();
        }
        if (end + 2 < ps) {
            p2 = constituents[end + 2];
        }
        this.surround(p_1, -1, type, p_1s, features);
        this.surround(p_2, -2, type, p_2s, features);
        this.surround(p1, 1, type, p1s, features);
        this.surround(p2, 2, type, p2s, features);
        return features.toArray(new String[features.size()]);
    }
}

