/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.tokenize;

import java.util.ArrayList;
import java.util.List;
import opennlp.maxent.ContextGenerator;
import opennlp.tools.util.ObjectIntPair;

public class TokContextGenerator
implements ContextGenerator {
    public static final String SPLIT = "T";
    public static final String NO_SPLIT = "F";

    public String[] getContext(Object o) {
        String sb = (String)((ObjectIntPair)o).a;
        int id = ((ObjectIntPair)o).b;
        ArrayList<String> preds = new ArrayList<String>();
        preds.add("p=" + sb.substring(0, id));
        preds.add("s=" + sb.substring(id));
        if (id > 0) {
            this.addCharPreds("p1", sb.charAt(id - 1), preds);
            if (id > 1) {
                this.addCharPreds("p2", sb.charAt(id - 2), preds);
                preds.add("p21=" + sb.charAt(id - 2) + sb.charAt(id - 1));
            } else {
                preds.add("p2=bok");
            }
            preds.add("p1f1=" + sb.charAt(id - 1) + sb.charAt(id));
        } else {
            preds.add("p1=bok");
        }
        this.addCharPreds("f1", sb.charAt(id), preds);
        if (id + 1 < sb.length()) {
            this.addCharPreds("f2", sb.charAt(id + 1), preds);
            preds.add("f12=" + sb.charAt(id) + sb.charAt(id + 1));
        } else {
            preds.add("f2=bok");
        }
        if (sb.charAt(0) == '&' && sb.charAt(sb.length() - 1) == ';') {
            preds.add("cc");
        }
        String[] context = new String[preds.size()];
        preds.toArray(context);
        return context;
    }

    private void addCharPreds(String key, char c, List preds) {
        preds.add(key + "=" + c);
        if (Character.isLetter(c)) {
            preds.add(key + "_alpha");
            if (Character.isUpperCase(c)) {
                preds.add(key + "_caps");
            }
        } else if (Character.isDigit(c)) {
            preds.add(key + "_num");
        } else if (Character.isWhitespace(c)) {
            preds.add(key + "_ws");
        } else if (c == '.' || c == '?' || c == '!') {
            preds.add(key + "_eos");
        } else if (c == '`' || c == '\"' || c == '\'') {
            preds.add(key + "_quote");
        } else if (c == '[' || c == '{' || c == '(') {
            preds.add(key + "_lp");
        } else if (c == ']' || c == '}' || c == ')') {
            preds.add(key + "_rp");
        }
    }
}

