/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.sentdetect;

import java.io.InputStreamReader;
import java.io.Reader;
import opennlp.maxent.ContextGenerator;
import opennlp.maxent.DataStream;
import opennlp.maxent.Event;
import opennlp.maxent.EventStream;
import opennlp.maxent.PlainTextByLineDataStream;
import opennlp.tools.sentdetect.DefaultEndOfSentenceScanner;
import opennlp.tools.sentdetect.EndOfSentenceScanner;
import opennlp.tools.sentdetect.SDContextGenerator;
import opennlp.tools.sentdetect.SDEvent;
import opennlp.tools.util.Pair;

public class SDEventStream
implements EventStream {
    private DataStream data;
    private String next;
    private SDEvent head = null;
    private SDEvent tail = null;
    private ContextGenerator cg;
    private StringBuffer sBuffer = new StringBuffer();
    private EndOfSentenceScanner scanner;

    public SDEventStream(DataStream d) {
        this(d, new DefaultEndOfSentenceScanner(), new SDContextGenerator(DefaultEndOfSentenceScanner.eosCharacters));
    }

    public SDEventStream(DataStream d, EndOfSentenceScanner s) {
        this(d, s, new SDContextGenerator(DefaultEndOfSentenceScanner.eosCharacters));
    }

    public SDEventStream(DataStream d, EndOfSentenceScanner s, ContextGenerator cg) {
        this.data = d;
        this.scanner = s;
        this.cg = cg;
        if (this.data.hasNext()) {
            String current = (String)this.data.nextToken();
            if (this.data.hasNext()) {
                this.next = (String)this.data.nextToken();
            }
            this.addNewEvents(current);
        }
    }

    public Event nextEvent() {
        SDEvent top = this.head;
        this.head = this.head.next;
        if (null == this.head) {
            this.tail = null;
        }
        return top;
    }

    private void addNewEvents(String s) {
        int posAfterFirstWordInNext;
        StringBuffer sb = this.sBuffer;
        sb.append(s.trim());
        int sentEndPos = sb.length() - 1;
        if (this.next != null && !s.equals("") && (posAfterFirstWordInNext = this.next.indexOf(" ")) != -1) {
            sb.append(" ");
            sb.append(this.next.substring(0, posAfterFirstWordInNext));
        }
        for (Integer candidate : this.scanner.getPositions(sb)) {
            Pair p = new Pair(sb, candidate);
            String type = candidate == sentEndPos ? "T" : "F";
            SDEvent evt = new SDEvent(type, this.cg.getContext((Object)p));
            if (null != this.tail) {
                this.tail.next = evt;
                this.tail = evt;
                continue;
            }
            if (null == this.head) {
                this.head = evt;
                continue;
            }
            if (null != this.head.next) continue;
            this.head.next = this.tail = evt;
        }
        sb.setLength(0);
    }

    public boolean hasNext() {
        if (null != this.head) {
            return true;
        }
        while (null == this.head && this.next != null) {
            String current = this.next;
            this.next = this.data.hasNext() ? (String)this.data.nextToken() : null;
            this.addNewEvents(current);
        }
        return null != this.head;
    }

    public static void main(String[] args) {
        SDEventStream es = new SDEventStream((DataStream)new PlainTextByLineDataStream((Reader)new InputStreamReader(System.in)));
        while (es.hasNext()) {
            System.out.println(es.nextEvent());
        }
    }
}

