/*
 * Decompiled with CFR 0.152.
 */
package opennlp.maxent;

import opennlp.maxent.MaxentModel;
import opennlp.maxent.ModelSetter;

public class ModelReplacementManager {
    private ModelSetter setter;
    private int users = 0;
    private boolean replacementCanProceed = true;
    private Thread replacementThread = null;

    public ModelReplacementManager(ModelSetter ms) {
        this.setter = ms;
    }

    public void startUsingModel() {
        if (this.replacementThread != null) {
            try {
                this.replacementThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.replacementCanProceed = false;
        ++this.users;
    }

    public void finishUsingModel() {
        --this.users;
        if (this.users <= 0) {
            this.replacementCanProceed = true;
        }
    }

    public synchronized void replaceModel(MaxentModel model) {
        this.replacementThread = Thread.currentThread();
        while (!this.replacementCanProceed) {
            Thread.yield();
        }
        this.setter.setModel(model);
        this.replacementThread = null;
    }
}

