/*
 * Decompiled with CFR 0.152.
 */
package opennlp.uima.postag;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import opennlp.maxent.GIS;
import opennlp.tools.postag.POSDictionary;
import opennlp.tools.postag.POSModel;
import opennlp.tools.postag.POSSample;
import opennlp.tools.postag.POSTaggerME;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.ObjectStreamUtils;
import opennlp.tools.util.model.BaseModel;
import opennlp.tools.util.model.ModelType;
import opennlp.uima.util.AnnotatorUtil;
import opennlp.uima.util.CasConsumerUtil;
import opennlp.uima.util.ContainingConstraint;
import opennlp.uima.util.OpennlpUtil;
import opennlp.uima.util.UimaUtil;
import org.apache.uima.UimaContext;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FSMatchConstraint;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.collection.CasConsumer_ImplBase;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceProcessException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;
import org.apache.uima.util.ProcessTrace;

public class POSTaggerTrainer
extends CasConsumer_ImplBase {
    public static final String TAG_DICTIONARY_NAME = "opennlp.uima.TagDictionaryName";
    private UimaContext mContext;
    private Type mSentenceType;
    private Type mTokenType;
    private String mModelName;
    private Feature mPOSFeature;
    private Logger mLogger;
    private List<POSSample> mPOSSamples = new ArrayList<POSSample>();
    private String language;
    private POSDictionary tagDictionary;

    public void initialize() throws ResourceInitializationException {
        block4: {
            super.initialize();
            this.mContext = this.getUimaContext();
            this.mLogger = this.mContext.getLogger();
            if (this.mLogger.isLoggable(Level.INFO)) {
                this.mLogger.log(Level.INFO, "Initializing the OpenNLP POSTagger trainer.");
            }
            this.mModelName = CasConsumerUtil.getRequiredStringParameter(this.mContext, UimaUtil.MODEL_PARAMETER);
            this.language = CasConsumerUtil.getRequiredStringParameter(this.mContext, "opennlp.uima.Language");
            String tagDictionaryName = CasConsumerUtil.getOptionalStringParameter(this.mContext, TAG_DICTIONARY_NAME);
            if (tagDictionaryName != null) {
                try {
                    InputStream dictIn = AnnotatorUtil.getResourceAsStream(this.mContext, tagDictionaryName);
                    this.tagDictionary = new POSDictionary(new BufferedReader(new InputStreamReader(dictIn)), false);
                }
                catch (IOException e) {
                    String message = "IOException during tag dictionary reading, running without tag dictionary: " + e.getMessage();
                    if (!this.mLogger.isLoggable(Level.WARNING)) break block4;
                    this.mLogger.log(Level.WARNING, message);
                }
            }
        }
    }

    public void typeSystemInit(TypeSystem typeSystem) throws ResourceInitializationException {
        String sentenceTypeName = CasConsumerUtil.getRequiredStringParameter(this.mContext, UimaUtil.SENTENCE_TYPE_PARAMETER);
        if (this.mLogger.isLoggable(Level.INFO)) {
            this.mLogger.log(Level.INFO, UimaUtil.SENTENCE_TYPE_PARAMETER + ": " + sentenceTypeName);
        }
        this.mSentenceType = CasConsumerUtil.getType(typeSystem, sentenceTypeName);
        String tokenTypeName = CasConsumerUtil.getRequiredStringParameter(this.mContext, "opennlp.uima.TokenType");
        this.mTokenType = CasConsumerUtil.getType(typeSystem, tokenTypeName);
        String posFeatureName = CasConsumerUtil.getRequiredStringParameter(this.mContext, "opennlp.uima.POSFeature");
        this.mPOSFeature = this.mTokenType.getFeatureByBaseName(posFeatureName);
    }

    public void processCas(CAS cas) {
        AnnotationIndex sentenceAnnotations = cas.getAnnotationIndex(this.mSentenceType);
        for (AnnotationFS sentence : sentenceAnnotations) {
            this.process(cas, sentence);
        }
    }

    private void process(CAS tcas, AnnotationFS sentence) {
        AnnotationIndex allTokens = tcas.getAnnotationIndex(this.mTokenType);
        ContainingConstraint containingConstraint = new ContainingConstraint(sentence);
        ArrayList<String> tokens = new ArrayList<String>();
        ArrayList<String> tags = new ArrayList<String>();
        FSIterator containingTokens = tcas.createFilteredIterator(allTokens.iterator(), (FSMatchConstraint)containingConstraint);
        while (containingTokens.hasNext()) {
            AnnotationFS tokenAnnotation = (AnnotationFS)containingTokens.next();
            String tag = tokenAnnotation.getFeatureValueAsString(this.mPOSFeature);
            tokens.add(tokenAnnotation.getCoveredText().trim());
            tags.add(tag);
        }
        this.mPOSSamples.add(new POSSample(tokens, tags));
    }

    public void collectionProcessComplete(ProcessTrace trace) throws ResourceProcessException, IOException {
        GIS.PRINT_MESSAGES = false;
        POSModel posTaggerModel = POSTaggerME.train((String)this.language, (ObjectStream)ObjectStreamUtils.createObjectStream(this.mPOSSamples), (ModelType)ModelType.MAXENT, (POSDictionary)this.tagDictionary, null, (int)100, (int)5);
        this.mPOSSamples = null;
        File modelFile = new File(this.getUimaContextAdmin().getResourceManager().getDataPath() + File.separatorChar + this.mModelName);
        OpennlpUtil.serialize((BaseModel)posTaggerModel, modelFile);
    }

    public boolean isStateless() {
        return false;
    }

    public void destroy() {
        this.mPOSSamples = null;
    }
}

