/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.data.list;

import java.io.PrintStream;
import java.util.ListIterator;
import net.didion.jwnl.JWNLRuntimeException;
import net.didion.jwnl.data.list.Node;
import net.didion.jwnl.util.TypeCheckingList;

public abstract class NodePrinter {
    private PrintStream _defaultStream = System.out;
    private int _defaultIndent = 0;

    public NodePrinter() {
    }

    public NodePrinter(int defaultIndent) {
        this._defaultIndent = defaultIndent;
    }

    public NodePrinter(PrintStream defaultStream) {
        this._defaultStream = defaultStream;
    }

    public NodePrinter(PrintStream defaultStream, int defaultIndent) {
        this._defaultStream = defaultStream;
        this._defaultIndent = defaultIndent;
    }

    protected abstract void print(PrintStream var1, Node var2, int var3, int var4);

    public void print(TypeCheckingList.TypeCheckingListIterator itr) {
        this.print(itr, this._defaultStream);
    }

    public void print(TypeCheckingList.TypeCheckingListIterator itr, PrintStream stream) {
        this.print(itr, stream, this._defaultIndent);
    }

    public void print(TypeCheckingList.TypeCheckingListIterator itr, PrintStream stream, int indent) {
        this.print(itr, stream, indent, indent);
    }

    public void print(TypeCheckingList.TypeCheckingListIterator itr, int indent) {
        this.print(itr, indent, indent);
    }

    public void print(TypeCheckingList.TypeCheckingListIterator itr, int indent, int indentIncrement) {
        this.print(itr, this._defaultStream, indent, indentIncrement);
    }

    public void print(TypeCheckingList.TypeCheckingListIterator itr, PrintStream stream, int indent, int indentIncrement) {
        NodeListIteratorWrapper pItr = new NodeListIteratorWrapper(itr);
        int curNode = pItr.currentIndex();
        pItr.moveToBeginning();
        while (itr.hasNext()) {
            this.print(stream, pItr.nextNode(), indent, indentIncrement);
        }
        pItr.moveTo(curNode);
    }

    private static final class NodeListIteratorWrapper {
        private ListIterator _itr;
        static /* synthetic */ Class class$0;

        public NodeListIteratorWrapper(TypeCheckingList.TypeCheckingListIterator itr) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("net.didion.jwnl.data.list.Node");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!clazz.isAssignableFrom(itr.getType())) {
                Object[] objectArray = new Object[2];
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("net.didion.jwnl.data.list.Node");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                objectArray[0] = clazz2;
                objectArray[1] = itr.getType();
                throw new JWNLRuntimeException("DATA_EXCEPTION_003", objectArray);
            }
            this._itr = itr;
        }

        public Node nextNode() {
            return (Node)this._itr.next();
        }

        public Node previousNode() {
            return (Node)this._itr.previous();
        }

        public int currentIndex() {
            return this._itr.nextIndex() - 1;
        }

        public int moveTo(int index) {
            block3: {
                block2: {
                    if (this.currentIndex() >= index) break block2;
                    while (this.currentIndex() < index && this._itr.hasNext()) {
                        this._itr.next();
                    }
                    break block3;
                }
                if (this.currentIndex() <= index) break block3;
                while (this.currentIndex() > index && this._itr.hasPrevious()) {
                    this._itr.previous();
                }
            }
            return this.currentIndex();
        }

        public void moveToBeginning() {
            this.moveTo(-1);
        }

        public void moveToFirst() {
            this.moveTo(0);
        }

        public void moveToLast() {
            this.moveTo(Integer.MAX_VALUE);
        }
    }
}

