/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.featuregen;

import java.util.ArrayList;
import java.util.List;
import opennlp.tools.util.featuregen.AdaptiveFeatureGenerator;
import opennlp.tools.util.featuregen.AggregatedFeatureGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowFeatureGenerator
implements AdaptiveFeatureGenerator {
    public static final String PREV_PREFIX = "p";
    public static final String NEXT_PREFIX = "n";
    private final AdaptiveFeatureGenerator generator;
    private final int prevWindowSize;
    private final int nextWindowSize;

    public WindowFeatureGenerator(AdaptiveFeatureGenerator generator, int prevWindowSize, int nextWindowSize) {
        this.generator = generator;
        this.prevWindowSize = prevWindowSize;
        this.nextWindowSize = nextWindowSize;
    }

    public WindowFeatureGenerator(int prevWindowSize, int nextWindowSize, AdaptiveFeatureGenerator ... generators) {
        this((AdaptiveFeatureGenerator)new AggregatedFeatureGenerator(generators), prevWindowSize, nextWindowSize);
    }

    public WindowFeatureGenerator(AdaptiveFeatureGenerator generator) {
        this(generator, 5, 5);
    }

    public WindowFeatureGenerator(AdaptiveFeatureGenerator ... generators) {
        this((AdaptiveFeatureGenerator)new AggregatedFeatureGenerator(generators), 5, 5);
    }

    @Override
    public void createFeatures(List<String> features, String[] tokens, int index, String[] preds) {
        int i;
        this.generator.createFeatures(features, tokens, index, preds);
        for (i = 1; i < this.prevWindowSize + 1; ++i) {
            if (index - i < 0) continue;
            ArrayList<String> prevFeatures = new ArrayList<String>();
            this.generator.createFeatures(prevFeatures, tokens, index - i, preds);
            for (String prevFeature : prevFeatures) {
                features.add(PREV_PREFIX + i + prevFeature);
            }
        }
        for (i = 1; i < this.nextWindowSize + 1; ++i) {
            if (i + index >= tokens.length) continue;
            ArrayList<String> nextFeatures = new ArrayList<String>();
            this.generator.createFeatures(nextFeatures, tokens, index + i, preds);
            for (String nextFeature : nextFeatures) {
                features.add(NEXT_PREFIX + i + nextFeature);
            }
        }
    }

    @Override
    public void updateAdaptiveData(String[] tokens, String[] outcomes) {
        this.generator.updateAdaptiveData(tokens, outcomes);
    }

    @Override
    public void clearAdaptiveData() {
        this.generator.clearAdaptiveData();
    }

    public String toString() {
        return super.toString() + ": Prev window size: " + this.prevWindowSize + ", Next window size: " + this.nextWindowSize;
    }
}

