% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correct_compl_junctions.R
\name{correct_compl_junctions}
\alias{correct_compl_junctions}
\title{Correct junctions with three inflows.}
\usage{
correct_compl_junctions(clean = TRUE, celltoldig = 2)
}
\arguments{
\item{clean}{logical; should intermediate files be removed from 'GRASS'
session?}

\item{celltoldig}{integer; number of digits the cell size dimensions are
rounded to before it is checked whether they are identical}
}
\value{
Nothing. The function changes features in \itemize{
  \item{'streams_v':} {Updated streams with topology (vector)}
  \item{'streams_r':} {Updated stream raster (new cat) (raster)} } and copies
  the original to \itemize{ \item{'streams_v_o':} {Originally derived streams
  with topology (vector)} \item{'streams_r_o':} {Originally derived stream
  raster (raster).} }
}
\description{
At complex junctions (i.e. more than two inflows to an outflow), the outflow
is broken into two segments at 1/4 of the DEM's cellsize downstream of the
start using
\href{https://grass.osgeo.org/grass73/manuals/v.edit.html}{v.edit}(tool =
break). Then, the stream with the smallest angle to the outflow is moved to
this new junction using
\href{https://grass.osgeo.org/grass73/manuals/v.edit.html}{v.edit}(tool =
vertexmove). So far, this function works only for junctions with three
inflows, not more.
}
\note{
\code{\link{setup_grass_environment}}, \code{\link{import_data}} and
  \code{\link{derive_streams}} must be run before.
}
\examples{
\donttest{
# Initiate GRASS session
if(.Platform$OS.type == "windows"){
  gisbase = "c:/Program Files/GRASS GIS 7.2.0"
  } else {
  gisbase = "/usr/lib/grass72/"
  }
initGRASS(gisBase = gisbase,
    home = tempdir(),
    override = TRUE)

# Load files into GRASS
dem_path <- system.file("extdata", "nc", "elev_ned_30m.tif", package = "openSTARS")
sites_path <- system.file("extdata", "nc", "sites_nc.shp", package = "openSTARS")
setup_grass_environment(dem = dem_path, sites = sites_path)
import_data(dem = dem_path, sites = sites_path)
gmeta()

# Derive streams from DEM
derive_streams(burn = 0, accum_threshold = 100, condition = TRUE, clean = TRUE)

# Check and correct complex junctions (there are complex juctions in the 
# example date set if the accumulation threshold is low)
cj <- check_compl_junctions()
if(cj){
  correct_compl_junctions()
}

# plot
dem <- readRAST('dem', ignore.stderr = TRUE)
streams <- readVECT('streams_v', ignore.stderr = TRUE)
streams_orig <- readVECT('streams_v_o', ignore.stderr = TRUE)
# zoom to a relevant part of the dem
plot(dem, col = terrain.colors(20), axes = TRUE, 
  xlim = c(640050,640200), ylim = c(219700,219850))
lines(streams_orig, col = 'red', lwd = 4)
lines(streams, col = 'blue', lty = 2, lwd = 2)
legend("topright", col = c("red", "blue"), lty = c(1,2), lwd = c(4,2), 
  legend = c("original", "corrected"))
}
}
\author{
Mira Kattwinkel \email{mira.kattwinkel@gmx.net}
}
