% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_binary.R, R/export_ssn.R
\name{calc_binary}
\alias{calc_binary}
\alias{calc_binary}
\title{Calculate binary IDs for each stream network.}
\usage{
calc_binary()

calc_binary()
}
\value{
A list with one slot for each network id containing a data frame
with 'rid' and 'binaryID' for each segment belonging to this network.

A list with one slot for each network id containing a data frame
with 'rid' and 'binaryID' for each segment belonging to this network.
}
\description{
Calculate binary IDs for each stream network built up by '0' and '1'.
This function is called by \code{\link{export_ssn}} and there is no need for it
be called by the users.

Calculate binary IDs for each stream network built up by '0' and '1'.
This function is called by \code{\link{export_ssn}} and there is no need for it
be called by the users.
}
\note{
\code{\link{import_data}}, \code{\link{derive_streams}},
  \code{\link{calc_edges}} and \code{\link{calc_sites}} must be run before.

\code{\link{import_data}}, \code{\link{derive_streams}},
  \code{\link{calc_edges}} and \code{\link{calc_sites}} must be run before.
}
\examples{
\donttest{
# Initiate GRASS session
if(.Platform$OS.type == "windows"){
  gisbase = "c:/Program Files/GRASS GIS 7.4.0"
  } else {
  gisbase = "/usr/lib/grass74/"
  }
initGRASS(gisBase = gisbase,
    home = tempdir(),
    override = TRUE)

# Load files into GRASS
dem_path <- system.file("extdata", "nc", "elev_ned_30m.tif", package = "openSTARS")
sites_path <- system.file("extdata", "nc", "sites_nc.shp", package = "openSTARS")
setup_grass_environment(dem = dem_path)
import_data(dem = dem_path, sites = sites_path)
gmeta()

# Derive streams from DEM
derive_streams(burn = 0, accum_threshold = 700, condition = TRUE, clean = TRUE)

# Check and correct complex junctions (there are no complex juctions in this 
# example date set)
cj <- check_compl_junctions()
if(cj){
  correct_compl_junctions()
}

# Prepare edges
calc_edges()

# Prepare site
calc_sites()

binaries <- calc_binary()
head(binaries[[1]])
}
}
\author{
Eduard Szoecs, \email{eduardszoecs@gmail.com}; Mira Kattwinkel, \email{mira.kattwinkel@gmx.net}

Eduard Szoecs, \email{eduardszoecs@gmail.com}; Mira Kattwinkel, \email{mira.kattwinkel@gmx.net}

 @export
}
