% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_edit.R
\name{create_edit}
\alias{create_edit}
\title{Create edit}
\usage{
create_edit(
  engine_id = deprecated(),
  model,
  input = "\\"",
  instruction,
  temperature = 1,
  top_p = 1,
  openai_api_key = Sys.getenv("OPENAI_API_KEY"),
  openai_organization = NULL
)
}
\arguments{
\item{engine_id}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}

\item{model}{required; a length one character vector.}

\item{input}{required; defaults to \code{'"'}; a length one character vector.}

\item{instruction}{required; a length one character vector.}

\item{temperature}{required; defaults to \code{1}; a length one numeric vector
with the value between \code{0} and \code{2}.}

\item{top_p}{required; defaults to \code{1}; a length one numeric vector with the
value between \code{0} and \code{1}.}

\item{openai_api_key}{required; defaults to \code{Sys.getenv("OPENAI_API_KEY")}
(i.e., the value is retrieved from the \code{.Renviron} file); a length one
character vector. Specifies OpenAI API key.}

\item{openai_organization}{optional; defaults to \code{NULL}; a length one
character vector. Specifies OpenAI organization.}
}
\value{
Returns a list, elements of which contain edited version of prompt
and supplementary information.
}
\description{
Creates an edit based on the provided input, instruction, and parameters. See
\href{https://beta.openai.com/docs/api-reference/edits/create}{this page} for
details.
}
\details{
For arguments description please refer to the \href{https://beta.openai.com/docs/api-reference/edits/create}{official documentation}.
}
\examples{
\dontrun{
create_edit(
    model = "text-davinci-edit-001",
    input = "What day of the wek is it?",
    instruction = "Fix the spelling mistakes"
)
}
}
