% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importMeta.R
\name{importMeta}
\alias{importMeta}
\title{Import monitoring site meta data for UK and European networks}
\usage{
importMeta(source = "aurn", all = FALSE, year = NA, duplicate = FALSE)
}
\arguments{
\item{source}{One or more air quality networks for which data is available
through openair. Available networks include:
\itemize{
\item \code{"aurn"},  The UK Automatic Urban and Rural Network.
\item \code{"aqe"},  The Air Quality England Network.
\item \code{"saqn"},  The Scottish Air Quality Network.
\item \code{"waqn"},  The Welsh Air Quality Network.
\item \code{"ni"},  The Northern Ireland Air Quality Network.
\item \code{"local"},  Locally managed air quality networks in England.
\item \code{"kcl"}, King's College London networks.
\item \code{"europe"}, European AirBase/e-reporting data.
There are two additional options provided for convenience:
\item \code{"ukaq"} will return metadata for all networks for which data is imported by \code{\link[=importUKAQ]{importUKAQ()}} (i.e., AURN, AQE, SAQN, WAQN, NI, and the local networks).
\item \code{"all"} will import all available metadata (i.e., \code{"ukaq"} plus \code{"kcl"} and \code{"europe"}).
}}

\item{all}{When \code{all = FALSE} only the site code, site name, latitude and
longitude and site type are imported. Setting \code{all = TRUE} will import all
available meta data and provide details (when available) or the individual
pollutants measured at each site.}

\item{year}{If a single year is selected, only sites that were open at some
point in that year are returned. If \code{all = TRUE} only sites that
measured a particular pollutant in that year are returned. Year can also be
a sequence e.g. \code{year = 2010:2020} or of length 2 e.g. \code{year = c(2010, 2020)}, which will return only sites that were open over the
duration. Note that \code{year} is ignored when the \code{source} is either
\code{"kcl"} or \code{"europe"}.}

\item{duplicate}{Some UK air quality sites are part of multiple networks, so
could appear more than once when \code{source} is a vector of two or more. The
default argument, \code{FALSE}, drops duplicate sites. \code{TRUE} will return them.}
}
\value{
A data frame with meta data.
}
\description{
Function to import meta data for air quality monitoring sites. By default,
the function will return the site latitude, longitude and site type, as well
as the code used in functions like \code{\link[=importUKAQ]{importUKAQ()}}, \code{\link[=importKCL]{importKCL()}} and
\code{\link[=importEurope]{importEurope()}}. Additional information may optionally be returned.
}
\details{
This function imports site meta data from several networks in the UK and
Europe:
\itemize{
\item \code{"aurn"},  The \href{https://uk-air.defra.gov.uk/}{UK Automatic Urban and Rural Network}.
\item \code{"aqe"},  The \href{https://www.airqualityengland.co.uk/}{Air Quality England Network}.
\item \code{"saqn"},  The \href{https://www.scottishairquality.scot/}{Scottish Air Quality Network}.
\item \code{"waqn"},  The \href{https://airquality.gov.wales/}{Welsh Air Quality Network}.
\item \code{"ni"},  The \href{https://www.airqualityni.co.uk/}{Northern Ireland Air Quality Network}.
\item \code{"local"},  Locally managed air quality networks in England.
\item \code{"kcl"},  King's College London networks.
\item \code{"europe"},  Hourly European data (\href{https://www.eea.europa.eu/data-and-maps/data/aqereporting-9}{Air Quality e-Reporting}) based on a
simplified version of the \code{{saqgetr}} package.
}

By default, the function will return the site latitude, longitude and site
type. If the option \code{all = TRUE} is used, much more detailed information is
returned. For most networks, this detailed information includes per-pollutant
summaries, opening and closing dates of sites etc.

Thanks go to Trevor Davies (Ricardo), Dr Stuart Grange (EMPA) and Dr Ben
Barratt (KCL) and  for making these data available.
}
\examples{
\dontrun{
# basic info:
meta <- importMeta(source = "aurn")

# more detailed information:
meta <- importMeta(source = "aurn", all = TRUE)

# from the Scottish Air Quality Network:
meta <- importMeta(source = "saqn", all = TRUE)

# from multiple networks:
meta <- importMeta(source = c("aurn", "aqe", "local"))
}
}
\seealso{
the \code{networkMap()} function from the \code{openairmaps} package which can
visualise site metadata on an interactive map.

Other import functions: 
\code{\link{importADMS}()},
\code{\link{importAURN}()},
\code{\link{importEurope}()},
\code{\link{importKCL}()},
\code{\link{importTraj}()},
\code{\link{importUKAQ}()}
}
\author{
David Carslaw
}
\concept{import functions}
