% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oaWorks2df.R
\name{oaWorks2df}
\alias{oaWorks2df}
\title{Convert OpenAlex collection of works from list format to data frame}
\usage{
oaWorks2df(data, verbose = TRUE)
}
\arguments{
\item{data}{is a list. data is the output of the function \code{oaApiRequest}.}

\item{verbose}{is a logical. If TRUE, information about the querying process will be plotted on screen. Default is \code{verbose=TRUE}.}
}
\value{
a data.frame.

For more extensive information about OpenAlex API, please visit: \href{https://docs.openalex.org/api}{https://docs.openalex.org/api}
}
\description{
It converts bibliographic collection of works gathered from OpenAlex database \href{https://openalex.org/}{https://openalex.org/} into data frame.
The function converts a list of works obtained using \code{oaApiRequest} into a data frame/tibble.
}
\examples{

\dontrun{

# Query to search all works citing the article:
#  Aria, M., & Cuccurullo, C. (2017). bibliometrix:
#   An R-tool for comprehensive science mapping analysis.
#   Journal of informetrics, 11(4), 959-975.

#  published in 2021.
#  The paper is associated to the OpenAlex id W2755950973.

#  Results have to be sorted by relevance score in a descending order.

query <- oaQueryBuild(
identifier=NULL,
entity = "works",
filter = "cites:W2755950973",
date_from = "2021-01-01",
date_to = "2021-12-31",
search=NULL,
endpoint = "https://api.openalex.org/")

res <- oaApiRequest(
   query_url = query,
   total.count = FALSE,
   verbose = FALSE
   )

df <- oa2df(res, entity = "works")

df

}

}
