% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openblender.R
\name{call}
\alias{call}
\title{Make HTTP request to \href{http://openblender.io}{openblender.io} services}
\usage{
call(action, parameters)
}
\arguments{
\item{action}{Task you're requesting}

\item{parameters}{Request options}
}
\value{
A list that includes the new dataset id in case you create one, success/error message when you insert observations or the list of observations requested.
}
\description{
Call 'OpenBlender' API services.
}
\examples{
\dontrun{
#CREATE DATASET
df <- read.csv(file = "/path/to/your/data.csv", header = TRUE, sep = ",")
action <- "API_createDataset"
parameters <- list(
token = "YOUR TOKEN",
id_user = "YOUR USER ID",
name = "Assign a name",
descriptipon = "Set a description",
visibility = "public",
tags = list("topic", "tag"),
insert_observations = "off",# set "on" if you want include the observations
dataframe = df
)
call(action, parameters)
#INSERT OBSERVATIONS
df <- read.csv(file = "/path/to/your/data.csv", header = TRUE, sep = ",")
action <- "API_insertObservations"
parameters <- list(
token = "YOUR TOKEN",
id_user = "YOUR USER ID",
id_dataset = "DATASET ID",
notification = "on",
observations = df
)
call(action, parameters)

#GET OBSERVATIONS
action <- "API_getObservationsFromDataset"
parameters <- list(
token = "YOUR TOKEN",
id_user = "YOUR USER ID",
id_dataset = "DATASET ID"
)
call(action, parameters)
}
}
\seealso{
To see more details go to \href{http://openblender.io}{openblender.io}
}
