% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keypoints.R
\name{ocv_keypoints}
\alias{ocv_keypoints}
\title{OpenCV keypoints}
\usage{
ocv_keypoints(
  image,
  method = c("FAST", "Harris"),
  control = ocv_keypoints_options(method, ...),
  ...
)
}
\arguments{
\item{image}{an ocv grayscale image object}

\item{method}{the type of keypoint detection algorithm}

\item{control}{a list of arguments passed on to the algorithm}

\item{...}{further arguments passed on to ocv_keypoints_options}
}
\description{
Find key points in images
}
\section{FAST algorithm arguments}{

\itemize{
\item threshold threshold on difference between intensity of the central pixel and pixels of a circle around this pixel.
\item nonmaxSuppression if true, non-maximum suppression is applied to detected corners (keypoints).
\item type one of the three neighborhoods as defined in the paper: TYPE_9_16, TYPE_7_12, TYPE_5_8
}
}

\section{Harris algorithm arguments}{

\itemize{
\item numOctaves the number of octaves in the scale-space pyramid
\item corn_thresh the threshold for the Harris cornerness measure
\item DOG_thresh the threshold for the Difference-of-Gaussians scale selection
\item maxCorners the maximum number of corners to consider
\item num_layers the number of intermediate scales per octave
}
}

\examples{
mona <- ocv_read('https://jeroen.github.io/images/monalisa.jpg')
mona <- ocv_resize(mona, width = 320, height = 477)

# FAST-9
pts <- ocv_keypoints(mona, method = "FAST", type = "TYPE_9_16", threshold = 40)
# Harris
pts <- ocv_keypoints(mona, method = "Harris", maxCorners = 50)

# Convex Hull of points
pts <- ocv_chull(pts)

\dontshow{
ocv_destroy(mona)
}
}
