% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-gradestv.R
\docType{data}
\name{gradestv}
\alias{gradestv}
\title{Simulated data for analyzing the relationship between watching TV and grades}
\format{
A data frame with 25 observations on the following 2 variables.
\describe{
  \item{tv}{Number of hours per week students watch TV.}
  \item{grades}{Grades students got in a statistics class (out of 100).}
  }
}
\source{
Simulated data
}
\usage{
gradestv
}
\description{
This is a simulated data set to be used to estimate the relationship between
number of hours per week students watch TV and the grade they got in a
statistics class.
}
\details{
There are a few potential outliers in this data set. When analyzing the data
one should consider how (if at all) these outliers may affect the estimates
of correlation coefficient and regression parameters.
}
\examples{

library(ggplot2)

ggplot(gradestv, aes(x = tv, y = grades)) +
  geom_point() +
  geom_smooth(method = "lm")

}
\keyword{correlation}
\keyword{datasets}
\keyword{regression}
