% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-cle_sac.R
\docType{data}
\name{cle_sac}
\alias{cle_sac}
\title{Cleveland and Sacramento}
\format{
A data frame with 500 observations representing people on the
following 8 variables.
\describe{
\item{year}{Year the data was collected.}
\item{state}{State where person resides.}
\item{city}{City.}
\item{age}{Age.}
\item{sex}{Sex.}
\item{race}{Race.}
\item{marital_status}{Marital status.}
\item{personal_income}{Personal income.}
}
}
\usage{
cle_sac
}
\description{
Data on a sample of 500 people from the Cleveland, OH and Sacramento, CA
metro areas.
}
\examples{

library(ggplot2)

ggplot(cle_sac, aes(x = personal_income)) +
  geom_histogram(binwidth = 20000) +
  facet_wrap(~city)
}
\keyword{datasets}
