% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/CommentClass.R
\name{writeComment}
\alias{writeComment}
\title{write a cell comment}
\usage{
writeComment(wb, sheet, col, row, comment, xy = NULL)
}
\arguments{
\item{wb}{A workbook object}

\item{sheet}{A vector of names or indices of worksheets}

\item{col}{Column a column number of letter}

\item{row}{A row number.}

\item{comment}{A Comment object. See \code{\link{createComment}}.}

\item{xy}{An alternative to specifying \code{col} and
\code{row} individually.  A vector of the form
\code{c(col, row)}.}
}
\description{
write a cell comment
}
\examples{
wb <- createWorkbook()
addWorksheet(wb, "Sheet 1")

c1 <- createComment(comment = "this is comment")
writeComment(wb, 1, col = "B", row = 10, comment = c1)

s1 <- createStyle(fontSize = 12, fontColour = "red", textDecoration = c("BOLD"))
s2 <- createStyle(fontSize = 9, fontColour = "black")

c2 <- createComment(comment = c("This Part Bold red\\n\\n", "This part black"), style = c(s1, s2))
c2

writeComment(wb, 1, col = 6 , row = 3, comment = c2)

saveWorkbook(wb, file = "writeCommentExample.xlsx", overwrite = TRUE)
}
\seealso{
\code{\link{createComment}}
}

