% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/writeData.R
\name{writeData}
\alias{writeData}
\title{Write an object to a worksheet}
\usage{
writeData(wb, sheet, x, startCol = 1, startRow = 1, xy = NULL,
  colNames = TRUE, rowNames = FALSE, headerStyle = NULL,
  borders = c("none", "surrounding", "rows", "columns", "all"),
  borderColour = getOption("openxlsx.borderColour", "black"),
  borderStyle = getOption("openxlsx.borderStyle", "thin"),
  withFilter = FALSE, keepNA = FALSE)
}
\arguments{
\item{wb}{A Workbook object containing a worksheet.}

\item{sheet}{The worksheet to write to. Can be the worksheet index or name.}

\item{x}{Object to be written. For classes supported look at the examples.}

\item{startCol}{A vector specifiying the starting column to write to.}

\item{startRow}{A vector specifiying the starting row to write to.}

\item{xy}{An alternative to specifying \code{startCol} and
\code{startRow} individually.  A vector of the form
\code{c(startCol, startRow)}.}

\item{colNames}{If \code{TRUE}, column names of x are written.}

\item{rowNames}{If \code{TRUE}, data.frame row names of x are written.}

\item{headerStyle}{Custom style to apply to column names.}

\item{borders}{Either "\code{none}" (default), "\code{surrounding}",
"\code{columns}", "\code{rows}" or \emph{respective abbreviations}.  If
"\code{surrounding}", a border is drawn around the data.  If "\code{rows}",
a surrounding border is drawn with a border around each row. If
"\code{columns}", a surrounding border is drawn with a border between
each column. If "\code{all}" all cell borders are drawn.}

\item{borderColour}{Colour of cell border.  A valid colour (belonging to \code{colours()} or a hex colour code, eg see \href{http://www.colorpicker.com}{here}).}

\item{borderStyle}{Border line style
\itemize{
   \item{\bold{none}}{ no border}
   \item{\bold{thin}}{ thin border}
   \item{\bold{medium}}{ medium border}
   \item{\bold{dashed}}{ dashed border}
   \item{\bold{dotted}}{ dotted border}
   \item{\bold{thick}}{ thick border}
   \item{\bold{double}}{ double line border}
   \item{\bold{hair}}{ hairline border}
   \item{\bold{mediumDashed}}{ medium weight dashed border}
   \item{\bold{dashDot}}{ dash-dot border}
   \item{\bold{mediumDashDot}}{ medium weight dash-dot border}
   \item{\bold{dashDotDot}}{ dash-dot-dot border}
   \item{\bold{mediumDashDotDot}}{ medium weight dash-dot-dot border}
   \item{\bold{slantDashDot}}{ slanted dash-dot border}
  }}

\item{withFilter}{If \code{TRUE}, add filters to the column name row. NOTE can only have one filter per worksheet.}

\item{keepNA}{If \code{TRUE}, NA values are converted to #N/A in Excel else NA cells will be empty.}
}
\description{
Write an object to worksheet with optional styling.
}
\details{
Formulae written using writeFormula to a Workbook object will not get picked up by read.xlsx().
This is because only the formula is written and left to Excel to evaluate the formula when the file is opened in Excel.
}
\examples{
## See formatting vignette for further examples.

wb <- createWorkbook()
options("openxlsx.borderStyle" = "thin")
options("openxlsx.borderColour" = "#4F81BD")
## Add worksheets
addWorksheet(wb, "Cars")


x <- mtcars[1:6,]
writeData(wb, "Cars", x, startCol = 2, startRow = 3, rowNames = TRUE)
writeData(wb, "Cars", x, rowNames = TRUE, startCol = "O", startRow = 3,
         borders="surrounding", borderColour = "black") ## black border

writeData(wb, "Cars", x, rowNames = TRUE,
         startCol = 2, startRow = 12, borders="columns")

writeData(wb, "Cars", x, rowNames = TRUE,
         startCol="O", startRow = 12, borders="rows")

## header styles
hs1 <- createStyle(fgFill = "#DCE6F1", halign = "CENTER", textDecoration = "Italic",
                   border = "Bottom")

writeData(wb, "Cars", x, colNames = TRUE, rowNames = TRUE, startCol="B",
     startRow = 23, borders="rows", headerStyle = hs1, borderStyle = "dashed")

hs2 <- createStyle(fontColour = "#ffffff", fgFill = "#4F80BD",
                   halign = "center", valign = "center", textDecoration = "Bold",
                   border = "TopBottomLeftRight")

writeData(wb, "Cars", x, colNames = TRUE, rowNames = TRUE,
          startCol="O", startRow = 23, borders="columns", headerStyle = hs2)

## Write a hyperlink vector
v <- rep("http://cran.r-project.org/", 4)
names(v) <- paste("Hyperlink", 1:4) # Names will be used as display text
class(v) <- 'hyperlink'
writeData(wb, "Cars", x = v, xy = c("B", 32))


addWorksheet(wb, "Formula")

## create column of class "formula"
df <- data.frame(x=1:3, y = 1:3,
                 z = paste(paste0("A", 1:3+1L), paste0("B", 1:3+1L), sep = " + "),
                 stringsAsFactors = FALSE)

class(df$z) <- c(class(df$z), "formula")

writeData(wb, sheet = "Formula", x = df)



## Save workbook
saveWorkbook(wb, "writeDataExample.xlsx", overwrite = TRUE)
}
\author{
Alexander Walker
}
\seealso{
\code{\link{writeDataTable}}
}

