% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wb_styles.R
\name{set_cell_style}
\alias{set_cell_style}
\title{helper set_cell_style}
\usage{
set_cell_style(wb, sheet, cell, value)
}
\arguments{
\item{wb}{a workbook}

\item{sheet}{a worksheet}

\item{cell}{a cell}

\item{value}{a value to assign}
}
\description{
helper set_cell_style
}
\examples{
wb <- wb_workbook()
wb$add_worksheet("test")

mat <- matrix(rnorm(28*28, mean = 44444, sd = 555), ncol = 28)
wb$add_data("test", mat, colNames = FALSE)


x <- c("0", "1", "2", "3", "4", "9", "10", "11", "12", "13", "14", "15", "16",
       "17", "18", "19", "20", "21", "22", "37", "38", "39", "40", "45", "46",
       "47", "48", "49")

new_cellxfs <- create_cell_style(numFmtId = x, horizontal = "center")

# combine original and new styles
wb <- merge_cellXfs(wb, new_cellxfs)
wb_styles <- attr(wb, "wb_styles")

# new styles are 1:28, because s in a 0-index
for (i in wb_styles) {
  cell <- sprintf("\%s1:\%s28", int2col(i), int2col(i))
  wb$set_cell_style("test", cell, as.character(i))
}

\donttest{
# look at the beauty you've created
if (interactive()) wb_open(wb)
}
}
