% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_workbook}
\alias{wb_workbook}
\title{Create a new Workbook object}
\usage{
wb_workbook(
  creator = NULL,
  title = NULL,
  subject = NULL,
  category = NULL,
  datetimeCreated = Sys.time()
)
}
\arguments{
\item{creator}{Creator of the workbook (your name). Defaults to login username}

\item{title}{Workbook properties title}

\item{subject}{Workbook properties subject}

\item{category}{Workbook properties category}

\item{datetimeCreated}{The time of the workbook is created}
}
\value{
A \link{wbWorkbook} object
}
\description{
Create a new Workbook object
}
\examples{
## Create a new workbook
wb <- wb_workbook()

## Set Workbook properties
wb <- wb_workbook(
  creator  = "Me",
  title    = "Expense Report",
  subject  = "Expense Report - 2022 Q1",
  category = "sales"
)
}
\seealso{
Other workbook wrappers: 
\code{\link{wb_add_chartsheet}()},
\code{\link{wb_add_data_table}()},
\code{\link{wb_add_data}()},
\code{\link{wb_add_formula}()},
\code{\link{wb_add_worksheet}()},
\code{\link{wb_clone_worksheet}()},
\code{\link{wb_creators}},
\code{\link{wb_freeze_pane}()},
\code{\link{wb_get_base_font}()},
\code{\link{wb_save}()},
\code{\link{wb_set_col_widths}()},
\code{\link{wb_set_last_modified_by}()},
\code{\link{wb_set_row_heights}()},
\code{\link{workbook_grouping}},
\code{\link{ws_cell_merge}}
}
\concept{workbook wrappers}
