% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_copy_cells}
\alias{wb_copy_cells}
\title{copy cells around}
\usage{
wb_copy_cells(
  wb,
  sheet = current_sheet(),
  dims = "A1",
  data,
  as_value = FALSE,
  as_ref = FALSE,
  transpose = FALSE
)
}
\arguments{
\item{wb}{workbook}

\item{sheet}{a worksheet}

\item{dims}{cell used as start}

\item{data}{a wb_data object}

\item{as_value}{should a copy of the value be written}

\item{as_ref}{should references to the cell be written}

\item{transpose}{should the data be written transposed}
}
\value{
the wbWorkbook invisibly
}
\description{
copy cells around
}
\examples{
wb <- wb_workbook()$
add_worksheet()$
  add_data(x = mtcars)$
  add_fill(dims = "A1:F1", color = wb_color("yellow"))

dat <- wb_data(wb, dims = "A1:D4", colNames = FALSE)

wb$
  # 1:1 copy to M2
  clone_worksheet(old = 1, new = "Clone1")$
  copy_cells(data = dat, dims = "M2")
}
\seealso{
Other workbook wrappers: 
\code{\link{wb_add_chartsheet}()},
\code{\link{wb_add_data_table}()},
\code{\link{wb_add_data}()},
\code{\link{wb_add_formula}()},
\code{\link{wb_add_pivot_table}()},
\code{\link{wb_add_worksheet}()},
\code{\link{wb_clone_worksheet}()},
\code{\link{wb_creators}},
\code{\link{wb_freeze_pane}()},
\code{\link{wb_get_base_font}()},
\code{\link{wb_save}()},
\code{\link{wb_set_col_widths}()},
\code{\link{wb_set_last_modified_by}()},
\code{\link{wb_set_row_heights}()},
\code{\link{wb_workbook}()},
\code{\link{workbook_grouping}},
\code{\link{ws_cell_merge}}
}
\concept{workbook wrappers}
