% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wb_styles.R
\name{create_numfmt}
\alias{create_numfmt}
\title{Create number format}
\usage{
create_numfmt(numFmtId, formatCode)
}
\arguments{
\item{numFmtId}{An ID representing the number format. The list of valid IDs can be found in the \strong{Details} section of \code{\link[=create_cell_style]{create_cell_style()}}.}

\item{formatCode}{A format code that specifies the display format for numbers. This can include custom formats for dates, times, and other numeric values.}
}
\value{
A formatted number format object to be used in a spreadsheet.
}
\description{
This function creates a number format for a cell in a spreadsheet. Number formats define how numeric values are displayed, including dates, times, currencies, percentages, and more.
}
\examples{
# Create a number format for currency
numfmt <- create_numfmt(
  numFmtId = 164,
  formatCode = "$#,##0.00"
)

}
\seealso{
\code{\link[=wb_add_numfmt]{wb_add_numfmt()}}

Other style creating functions: 
\code{\link{create_border}()},
\code{\link{create_cell_style}()},
\code{\link{create_colors_xml}()},
\code{\link{create_dxfs_style}()},
\code{\link{create_fill}()},
\code{\link{create_font}()},
\code{\link{create_tablestyle}()}
}
\concept{style creating functions}
