% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openxlsx2-package.R
\docType{package}
\name{openxlsx2-package}
\alias{openxlsx2}
\alias{openxlsx2-package}
\title{xlsx reading, writing and editing.}
\description{
This R package is a modern reinterpretation of the widely used popular
\code{openxlsx} package. Similar to its predecessor, it simplifies the creation of xlsx
files by providing a clean interface for writing, designing and editing worksheets.
Based on a powerful XML library and focusing on modern programming flows in pipes
or chains, \code{openxlsx2} allows to break many new ground.
}
\details{
By default, openxlsx2 uses the American English word for color (written with 'o' instead of the British English 'ou').
However, both spellings are supported.
So where the documentation uses a 'color', the function should also accept a 'colour'.
However, this is not indicated by the autocompletion.
\subsection{Authors and contributions}{

For a full list of all authors that have made this package possible and for whom we are grateful, please see:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{system.file("AUTHORS", package = "openxlsx2")
}\if{html}{\out{</div>}}

If you feel like you should be included on this list, please let us know.
If you have something to contribute, you are welcome.
If something is not working as expected, open issues or if you have solved an issue, open a pull request.
Please be respectful and be aware that we are volunteers doing this for fun in our unpaid free time.
We will work on problems when we have time or need.
}

\subsection{License}{

This package is licensed under the MIT license and
is based on \href{https://github.com/ycphs/openxlsx}{\code{openxlsx}} (by Alexander Walker and Philipp Schauberger; COPYRIGHT 2014-2022)
and \href{https://github.com/zeux/pugixml}{\code{pugixml}} (by Arseny Kapoulkine; COPYRIGHT 2006-2022). Both released under the MIT license.
}
}
\seealso{
\itemize{
\item \code{browseVignettes("openxlsx2")}
\item \code{\link[=wb_add_data]{wb_add_data()}}
\item \code{\link[=wb_add_data_table]{wb_add_data_table()}}
\item \code{\link[=wb_to_df]{wb_to_df()}}
\item \code{\link[=read_xlsx]{read_xlsx()}}
\item \code{\link[=write_xlsx]{write_xlsx()}}
\item \url{https://janmarvin.github.io/openxlsx2/}
for examples
}
}
\author{
\strong{Maintainer}: Jan Marvin Garbuszus \email{jan.garbuszus@ruhr-uni-bochum.de}

Authors:
\itemize{
  \item Jordan Mark Barbone \email{jmbarbone@gmail.com} (\href{https://orcid.org/0000-0001-9788-3628}{ORCID})
}

Other contributors:
\itemize{
  \item Oliver Roy [contributor]
  \item  openxlsx authors (openxlsx package) [copyright holder]
  \item Arseny Kapoulkine (Author of included pugixml code) [contributor, copyright holder]
}

}
\keyword{internal}
