% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_add_pivot_table}
\alias{wb_add_pivot_table}
\title{Add a pivot table to a worksheet}
\usage{
wb_add_pivot_table(
  wb,
  x,
  sheet = next_sheet(),
  dims = "A3",
  filter,
  rows,
  cols,
  data,
  fun,
  params,
  pivot_table,
  slicer
)
}
\arguments{
\item{wb}{A Workbook object containing a #' worksheet.}

\item{x}{A \code{data.frame} that inherits the \code{\link[=wb_data]{wb_data}} class.}

\item{sheet}{A worksheet containing a #'}

\item{dims}{The worksheet cell where the pivot table is placed}

\item{filter}{The column name(s) of \code{x} used for filter.}

\item{rows}{The column name(s) of \code{x} used as rows}

\item{cols}{The column names(s) of \code{x} used as cols}

\item{data}{The column name(s) of \code{x} used as data}

\item{fun}{A vector of functions to be used with \code{data}. See \strong{Details} for the list of available options.}

\item{params}{A list of parameters to modify pivot table creation. See \strong{Details} for available options.}

\item{pivot_table}{An optional name for the pivot table}

\item{slicer}{Any additional column name(s) of \code{x} used as slicer}
}
\description{
The data must be specified using \code{\link[=wb_data]{wb_data()}} to ensure the function works.
The sheet will be empty unless it is opened in spreadsheet software. Find
more details in the \href{https://janmarvin.github.io/ox2-book/chapters/openxlsx2_pivot_tables.html}{section about pivot tables}
in the openxlsx2 book.
}
\details{
The pivot table is not actually written to the worksheet, therefore the cell
region has to remain empty. What is written to the workbook is something
like a recipe how the spreadsheet software has to construct the pivot table
when opening the file.

It is possible to add slicers to the pivot table. For this the pivot
table has to be named and the variable used as slicer, must be part
of the selected pivot table names (\code{cols}, \code{rows}, \code{filter}, or
\code{slicer}). If these criteria are matched, a slicer can be added
using \code{\link[=wb_add_slicer]{wb_add_slicer()}}.

Be aware that you should always test on a copy if a \code{param} argument works
with a pivot table. Not only to check if the desired effect appears, but
first and foremost if the file loads. Wildly mixing params might brick the
output file and cause spreadsheet software to crash.

\code{fun} can be any of \code{AVERAGE}, \code{COUNT}, \code{COUNTA}, \code{MAX}, \code{MIN},
\code{PRODUCT}, \code{STDEV}, \code{STDEVP}, \code{SUM}, \code{VAR}, \code{VARP}.

\code{show_data_as} can be any of \code{normal}, \code{difference}, \code{percent}, \code{percentDiff},
\code{runTotal}, \code{percentOfRow}, \code{percentOfCol}, \code{percentOfTotal}, \code{index}.

Possible \code{params} arguments are listed below. Pivot tables accepts more
parameters, but they were either not tested or misbehaved (probably because
we misunderstood how the parameter should be used).

Boolean arguments:
\itemize{
\item apply_alignment_formats
\item apply_number_formats
\item apply_border_formats
\item apply_font_formats
\item apply_pattern_formats
\item apply_width_height_formats
\item no_style
\item compact
\item outline
\item compact_data
\item row_grand_totals
\item col_grand_totals
}

Table styles accepting character strings:
\itemize{
\item auto_format_id: style id as character in the range of 4096 to 4117
\item table_style: a predefined (pivot) table style \code{"TableStyleMedium23"}
\item show_data_as: accepts character strings as listed above
}

Miscellaneous:
\itemize{
\item numfmt: accepts vectors of the form \code{c(formatCode = "0.0\%")}
\item choose: select variables in the form of a named logical vector like
\code{c(agegp = 'x > "25-34"')} for the \code{esoph} dataset.
\item sort_item: named list of index or character vectors
}
}
\examples{
wb <- wb_workbook() \%>\% wb_add_worksheet() \%>\% wb_add_data(x = mtcars)

df <- wb_data(wb, sheet = 1)

wb <- wb \%>\%
  # default pivot table
  wb_add_pivot_table(df, dims = "A3",
    filter = "am", rows = "cyl", cols = "gear", data = "disp"
  ) \%>\%
  # with parameters
  wb_add_pivot_table(df,
    filter = "am", rows = "cyl", cols = "gear", data = "disp",
    params = list(no_style = TRUE, numfmt = c(formatCode = "##0.0"))
  )
}
\seealso{
\code{\link[=wb_data]{wb_data()}}

Other workbook wrappers: 
\code{\link{base_font-wb}},
\code{\link{col_widths-wb}},
\code{\link{creators-wb}},
\code{\link{grouping-wb}},
\code{\link{row_heights-wb}},
\code{\link{wb_add_chartsheet}()},
\code{\link{wb_add_data_table}()},
\code{\link{wb_add_data}()},
\code{\link{wb_add_formula}()},
\code{\link{wb_add_slicer}()},
\code{\link{wb_add_worksheet}()},
\code{\link{wb_clone_worksheet}()},
\code{\link{wb_copy_cells}()},
\code{\link{wb_freeze_pane}()},
\code{\link{wb_merge_cells}()},
\code{\link{wb_save}()},
\code{\link{wb_set_last_modified_by}()},
\code{\link{wb_workbook}()}

Other worksheet content functions: 
\code{\link{col_widths-wb}},
\code{\link{filter-wb}},
\code{\link{grouping-wb}},
\code{\link{named_region-wb}},
\code{\link{row_heights-wb}},
\code{\link{wb_add_conditional_formatting}()},
\code{\link{wb_add_data_table}()},
\code{\link{wb_add_data}()},
\code{\link{wb_add_formula}()},
\code{\link{wb_add_slicer}()},
\code{\link{wb_add_thread}()},
\code{\link{wb_freeze_pane}()},
\code{\link{wb_merge_cells}()}
}
\concept{workbook wrappers}
\concept{worksheet content functions}
