% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_copy_cells}
\alias{wb_copy_cells}
\title{Copy cells around within a worksheet}
\usage{
wb_copy_cells(
  wb,
  sheet = current_sheet(),
  dims = "A1",
  data,
  as_value = FALSE,
  as_ref = FALSE,
  transpose = FALSE,
  ...
)
}
\arguments{
\item{wb}{A workbook}

\item{sheet}{a worksheet}

\item{dims}{A cell where to place the copy}

\item{data}{A \code{\link[=wb_data]{wb_data}} object containing cells to copy}

\item{as_value}{Should a copy of the value be written?}

\item{as_ref}{Should references to the cell be written?}

\item{transpose}{Should the data be written transposed?}

\item{...}{additional arguments passed to add_data() if used with \code{as_value}}
}
\value{
the \code{wbWorkbook} invisibly
}
\description{
Copy cells around within a worksheet
}
\examples{
wb <- wb_workbook()$
add_worksheet()$
  add_data(x = mtcars)$
  add_fill(dims = "A1:F1", color = wb_color("yellow"))

dat <- wb_data(wb, dims = "A1:D4", col_names = FALSE)
# 1:1 copy to M2
wb$
  clone_worksheet(old = 1, new = "Clone1")$
  copy_cells(data = dat, dims = "M2")
}
\seealso{
\code{\link[=wb_data]{wb_data()}}

Other workbook wrappers: 
\code{\link{base_font-wb}},
\code{\link{col_widths-wb}},
\code{\link{creators-wb}},
\code{\link{grouping-wb}},
\code{\link{row_heights-wb}},
\code{\link{wb_add_chartsheet}()},
\code{\link{wb_add_data}()},
\code{\link{wb_add_data_table}()},
\code{\link{wb_add_formula}()},
\code{\link{wb_add_pivot_table}()},
\code{\link{wb_add_slicer}()},
\code{\link{wb_add_worksheet}()},
\code{\link{wb_base_colors}},
\code{\link{wb_clone_worksheet}()},
\code{\link{wb_freeze_pane}()},
\code{\link{wb_merge_cells}()},
\code{\link{wb_save}()},
\code{\link{wb_set_last_modified_by}()},
\code{\link{wb_workbook}()}
}
\concept{workbook wrappers}
