% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loss.R
\name{loss}
\alias{loss}
\title{Errors suffered by a sequence of predictions}
\usage{
loss(
  x,
  y,
  pred = NULL,
  loss.type = list(name = "square"),
  loss.gradient = FALSE
)
}
\arguments{
\item{x}{\code{numeric}. A vector of length \code{T} containing the sequence of prediction to be evaluated.}

\item{y}{\code{numeric}. A vector of length \code{T} that contains the observations to be predicted.}

\item{pred}{\code{numeric}. A vector of length \code{T} containing the sequence of real values.}

\item{loss.type}{\code{character, list or function} ("square").
\itemize{
     \item{character}{ Name of the loss to be applied ('square', 'absolute', 'percentage', or 'pinball');}
     \item{list}{ List with field \code{name} equal to the loss name. If using pinball loss, field \code{tau} 
     equal to the required quantile in [0,1];}
     \item{function}{ A custom loss as a function of two parameters.}
}}

\item{loss.gradient}{\code{boolean, function} (TRUE). 
\itemize{
     \item{boolean}{ If TRUE, the aggregation rule will not be directly applied to the loss function at hand,
     but to a gradient version of it. The aggregation rule is then similar to gradient descent aggregation rule. }
     \item{function}{ If loss.type is a function, the derivative should be provided to be used (it is not automatically 
     computed).}
}}
}
\value{
A vector of length \code{T} containing the sequence of
instantaneous losses suffered by the expert previsions (x) or the gradient computed on the aggregated previsions (pred).
}
\description{
The
function \code{loss} computes the sequence of instantaneous losses suffered
by the predictions in \code{x} to predict the observation in \code{y}.
}
\author{
Pierre Gaillard <pierre@gaillard.me>
}
