% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_random_solver.R
\name{add_random_solver}
\alias{add_random_solver}
\title{Add a random solver}
\usage{
add_random_solver(x, number_solutions = 1, verbose = TRUE)
}
\arguments{
\item{x}{\code{\link{ProjectProblem-class}} object.}

\item{number_solutions}{\code{integer} number of solutions desired.
Defaults to 1. Note that the number of returned solutions can sometimes
be less than the argument to \code{number_solutions} depending on the
argument to \code{solution_pool_method}, for example if 100
solutions are requested but only 10 unique solutions exist, then only 10
solutions will be returned.}

\item{verbose}{\code{logical} should information be printed while solving
optimization problems?}
}
\value{
\code{\link{ProjectProblem-class}} object with the solver added
  to it.
}
\description{
Specify that solutions should be generated using random processes. Although
prioritizations should be developed using optimization routines,
a portfolio of randomly generated solutions can be useful for evaluating
the effectiveness of solutions.
}
\details{
The algorithm used to randomly generate solutions depends on the
 the objective specified for the project prioritization
 \code{\link{problem}}.

 For objectives which maximize benefit subject to budgetary constraints
 (e.g. \code{\link{add_max_richness_objective}}):

 \enumerate{

 \item All locked in and zero-cost actions are initially
  selected for funding (excepting actions which are locked out).

 \item A project---and all of its associated actions---is randomly selected
   for funding (excepting projects associated with locked out actions,
   and projects which would cause the budget to be exceeded when added
   to the existing set of selected actions).

\item The previous step is repeated until no more projects can be
  selected for funding without the total cost of the prioritized actions
  exceeding the budget.

 }

For objectives which minimize cost subject to biodiversity constraints
(i.e. \code{\link{add_min_set_objective}}:

 \enumerate{

 \item All locked in and zero-cost actions are initially
  selected for funding (excepting actions which are locked out).

 \item A project---and all of its associated actions---is randomly selected
   for funding (excepting projects associated with locked out actions,
   and projects which would cause the budget to be exceeded when added
   to the existing set of selected actions).

\item The previous step is repeated until all of the persistence targets
  are met.

 }
}
\examples{
# load data
data(sim_projects, sim_features, sim_actions)

# build problem with random solver, and generate 100 random solutions
p1 <- problem(sim_projects, sim_actions, sim_features,
             "name", "success", "name", "cost", "name") \%>\%
     add_max_richness_objective(budget = 200) \%>\%
     add_binary_decisions() \%>\%
     add_random_solver(number_solutions = 100)

# print problem
print(p1)

# solve problem
s1 <- solve(p1)

# print solutions
print(s1)

# plot first random solution
plot(p1, s1)

# plot histogram of the objective values for the random solutions
hist(s1$obj, xlab = "Expected richness", xlim = c(0, 2.5),
     main = "Histogram of random solutions")

# since the objective values don't tell us much about the quality of the
# solutions, we can find the optimal solution and calculate how different
# each of the random solutions is from optimality

\donttest{
# find the optimal objective value using an exact algorithms solver
s2 <- p1 \%>\%
      add_default_solver() \%>\%
      solve()

# create new column in s1 with percent difference from optimality
s1$optimality_diff <- ((s2$obj - s1$obj) / s1$obj) * 100

# plot histogram showing the quality of the random solutions
# higher numbers indicate worse solutions
hist(s1$optimality_diff, xlab = "Difference from optimality (\%)",
     main = "Histogram of random solutions", xlim = c(0, 50))
}
}
\seealso{
\code{\link{solvers}}.
}
